/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.shadowizardlib.event;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.mindoth.shadowizardlib.client.KeyBinds;
import net.mindoth.shadowizardlib.network.PacketSyncClientEffects;
import net.mindoth.shadowizardlib.network.PacketToggleClientEffects;
import net.mindoth.shadowizardlib.network.ShadowNetwork;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ThanksList {
    static Map<UUID, SupporterParticleType> PARTICLES = new HashMap<UUID, SupporterParticleType>();
    public static final Set<UUID> DISABLED = new HashSet<UUID>();

    public static void init() {
        new Thread(() -> {
            try {
                URL url = new URL("https://raw.githubusercontent.com/Mindoth/shadowizardlib/main/thanks.txt");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String s;
                    while ((s = reader.readLine()) != null) {
                        String[] split = s.split(" ", 2);
                        if (split.length != 2) continue;
                        PARTICLES.put(UUID.fromString(split[0]), SupporterParticleType.valueOf(split[1]));
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!PARTICLES.isEmpty()) {
                MinecraftForge.EVENT_BUS.addListener(ThanksList::clientTick);
                MinecraftForge.EVENT_BUS.addListener(ThanksList::onClientJoin);
            }
        }, "ShadowizardLib Supporter Effect Loader").start();
    }

    public static void onClientJoin(PlayerEvent.PlayerLoggedInEvent event) {
        UUID id = event.getEntity().m_20148_();
        if (PARTICLES.get(id) != null) {
            ShadowNetwork.sendToAll(new PacketSyncClientEffects(0, id));
        }
    }

    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (KeyBinds.TOGGLE.m_90859_()) {
            ShadowNetwork.sendToServer(new PacketToggleClientEffects());
        }
        SupporterParticleType t = null;
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91073_ != null) {
            for (Player player : Minecraft.m_91087_().f_91073_.m_6907_()) {
                if (player.m_20145_() || player.f_19797_ * 3 % 2 != 0 || DISABLED.contains(player.m_20148_()) || (t = PARTICLES.get(player.m_20148_())) == null) continue;
                ClientLevel world = (ClientLevel)player.m_9236_();
                RandomSource rand = world.f_46441_;
                ParticleOptions type = t.type.get();
                world.m_7106_(type, player.m_20185_() + rand.m_188500_() * 0.4 - 0.2, player.m_20186_() + 0.1, player.m_20189_() + rand.m_188500_() * 0.4 - 0.2, 0.0, 0.0, 0.0);
            }
        }
    }

    public static enum SupporterParticleType {
        ASH(() -> ParticleTypes.f_123783_),
        CAMPFIRE_SMOKE(() -> ParticleTypes.f_123777_),
        CLOUD(() -> ParticleTypes.f_123796_),
        DMG_HEART(() -> ParticleTypes.f_123798_),
        DRAGON_BREATH(() -> ParticleTypes.f_123799_),
        ELECTRIC_SPARK(() -> ParticleTypes.f_175830_),
        END_ROD(() -> ParticleTypes.f_123810_),
        FIRE(() -> ParticleTypes.f_123744_),
        FIREWORK(() -> ParticleTypes.f_123815_),
        GLOW(() -> ParticleTypes.f_175827_),
        GROWTH(() -> ParticleTypes.f_123748_),
        HEART(() -> ParticleTypes.f_123750_),
        SCULK_SOUL(() -> ParticleTypes.f_235898_),
        SLIME(() -> ParticleTypes.f_123753_),
        SNEEZE(() -> ParticleTypes.f_123763_),
        SNOW(() -> ParticleTypes.f_123754_),
        SOUL(() -> ParticleTypes.f_123746_),
        SOUL_FIRE(() -> ParticleTypes.f_123745_),
        WITCH(() -> ParticleTypes.f_123771_);

        public final Supplier<ParticleOptions> type;

        private SupporterParticleType(Supplier<ParticleOptions> type) {
            this.type = type;
        }
    }
}

