/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.shadowizardlib.event;

import java.util.HashMap;
import java.util.Random;
import net.mindoth.shadowizardlib.client.particle.ember.ParticleColor;
import net.mindoth.shadowizardlib.network.PacketSendCustomParticles;
import net.mindoth.shadowizardlib.network.ShadowNetwork;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LightEvents {
    public static HashMap<String, Float> defaultStats() {
        HashMap<String, Float> stats = new HashMap<String, Float>();
        stats.put("red", Float.valueOf(-1.0f));
        stats.put("green", Float.valueOf(-1.0f));
        stats.put("blue", Float.valueOf(-1.0f));
        stats.put("type", Float.valueOf(1.0f));
        return stats;
    }

    public static ParticleColor getParticleColor(HashMap<String, Float> stats) {
        ParticleColor color = new ParticleColor(Mth.m_14143_((float)stats.get("red").floatValue()), Mth.m_14143_((float)stats.get("green").floatValue()), Mth.m_14143_((float)stats.get("blue").floatValue()));
        if (color.getRed() < 0.0f || color.getRed() > 255.0f || color.getGreen() < 0.0f || color.getGreen() > 255.0f || color.getBlue() < 0.0f || color.getBlue() > 255.0f) {
            int r = new Random().nextInt(0, 256);
            int g = new Random().nextInt(0, 256);
            int b = new Random().nextInt(0, 256);
            return new ParticleColor(r, g, b);
        }
        return color;
    }

    public static int getParticleType(HashMap<String, Float> stats) {
        return (int)Math.floor(stats.get("type").floatValue());
    }

    public static void generateParticles(Vec3 pos, Vec3 center, Level level, float size, int age, double vecX, double vecY, double vecZ, HashMap<String, Float> stats) {
        ParticleColor.IntWrapper color = new ParticleColor.IntWrapper(LightEvents.getParticleColor(stats));
        ShadowNetwork.sendToNearby(new PacketSendCustomParticles(color.r, color.g, color.b, size, age, false, LightEvents.getParticleType(stats), pos.f_82479_, pos.f_82480_, pos.f_82481_, vecX, vecY, vecZ), level, center);
    }

    public static void summonParticleLine(Vec3 startPos, Vec3 endPos, int amount, Vec3 center, Level level, float size, int age, HashMap<String, Float> stats) {
        double startX = startPos.f_82479_;
        double startY = startPos.f_82480_;
        double startZ = startPos.f_82481_;
        double endX = endPos.f_82479_;
        double endY = endPos.f_82480_;
        double endZ = endPos.f_82481_;
        double speed = 0.05;
        for (int k = 1; k < 1 + amount; ++k) {
            double vecX = new Random().nextDouble(2.0) + -1.0;
            double vecY = new Random().nextDouble(2.0) + -1.0;
            double vecZ = new Random().nextDouble(2.0) + -1.0;
            double lineX = startX * (1.0 - (double)k / (double)amount) + endX * ((double)k / (double)amount);
            double lineY = startY * (1.0 - (double)k / (double)amount) + endY * ((double)k / (double)amount);
            double lineZ = startZ * (1.0 - (double)k / (double)amount) + endZ * ((double)k / (double)amount);
            LightEvents.generateParticles(new Vec3(lineX, lineY, lineZ), center, level, size, age, vecX * speed, vecY * speed, vecZ * speed, stats);
        }
    }

    public static void addEnchantParticles(Entity target, float size, HashMap<String, Float> stats) {
        ParticleColor.IntWrapper color;
        Vec3 pos;
        double randZ;
        double randY;
        double randX;
        int age;
        double vecY;
        int i;
        double var = 0.15;
        double maxX = target.m_20191_().f_82291_ + var;
        double minX = target.m_20191_().f_82288_ - var;
        double maxZ = target.m_20191_().f_82293_ + var;
        double minZ = target.m_20191_().f_82290_ - var;
        double vecX = 0.0;
        double minVecY = 0.1;
        double maxVecY = 0.6;
        double vecZ = 0.0;
        for (i = 0; i < 4; ++i) {
            vecY = minVecY + (maxVecY - minVecY) * new Random().nextDouble();
            age = 11 - (int)((vecY - 0.1) * 20.0);
            randX = maxX;
            randY = target.m_20186_() + (target.m_20186_() + (double)(target.m_20206_() / 2.0f) - target.m_20186_()) * new Random().nextDouble();
            randZ = minZ + (maxZ - minZ) * new Random().nextDouble();
            pos = new Vec3(randX, randY, randZ);
            color = new ParticleColor.IntWrapper(LightEvents.getParticleColor(stats));
            ShadowNetwork.sendToPlayersTrackingEntity(new PacketSendCustomParticles(color.r, color.g, color.b, size, age, false, LightEvents.getParticleType(stats), pos.f_82479_, pos.f_82480_, pos.f_82481_, vecX, vecY, vecZ), target, true);
        }
        for (i = 0; i < 4; ++i) {
            vecY = minVecY + (maxVecY - minVecY) * new Random().nextDouble();
            age = 11 - (int)((vecY - 0.1) * 20.0);
            randX = minX;
            randY = target.m_20186_() + (target.m_20186_() + (double)(target.m_20206_() / 2.0f) - target.m_20186_()) * new Random().nextDouble();
            randZ = minZ + (maxZ - minZ) * new Random().nextDouble();
            pos = new Vec3(randX, randY, randZ);
            color = new ParticleColor.IntWrapper(LightEvents.getParticleColor(stats));
            ShadowNetwork.sendToPlayersTrackingEntity(new PacketSendCustomParticles(color.r, color.g, color.b, size, age, false, LightEvents.getParticleType(stats), pos.f_82479_, pos.f_82480_, pos.f_82481_, vecX, vecY, vecZ), target, true);
        }
        for (i = 0; i < 4; ++i) {
            vecY = minVecY + (maxVecY - minVecY) * new Random().nextDouble();
            age = 11 - (int)((vecY - 0.1) * 20.0);
            randX = minX + (maxX - minX) * new Random().nextDouble();
            randY = target.m_20186_() + (target.m_20186_() + (double)(target.m_20206_() / 2.0f) - target.m_20186_()) * new Random().nextDouble();
            randZ = minZ;
            pos = new Vec3(randX, randY, randZ);
            color = new ParticleColor.IntWrapper(LightEvents.getParticleColor(stats));
            ShadowNetwork.sendToPlayersTrackingEntity(new PacketSendCustomParticles(color.r, color.g, color.b, size, age, false, LightEvents.getParticleType(stats), pos.f_82479_, pos.f_82480_, pos.f_82481_, vecX, vecY, vecZ), target, true);
        }
        for (i = 0; i < 4; ++i) {
            vecY = minVecY + (maxVecY - minVecY) * new Random().nextDouble();
            age = 11 - (int)((vecY - 0.1) * 20.0);
            randX = minX + (maxX - minX) * new Random().nextDouble();
            randY = target.m_20186_() + (target.m_20186_() + (double)(target.m_20206_() / 2.0f) - target.m_20186_()) * new Random().nextDouble();
            randZ = maxZ;
            pos = new Vec3(randX, randY, randZ);
            color = new ParticleColor.IntWrapper(LightEvents.getParticleColor(stats));
            ShadowNetwork.sendToPlayersTrackingEntity(new PacketSendCustomParticles(color.r, color.g, color.b, size, age, false, LightEvents.getParticleType(stats), pos.f_82479_, pos.f_82480_, pos.f_82481_, vecX, vecY, vecZ), target, true);
        }
    }

    public static void addAoeParticles(boolean targetBlocks, Level level, AABB box, float size, int age, HashMap<String, Float> stats) {
        Vec3 center = box.m_82399_();
        double maxX = box.f_82291_;
        double minX = box.f_82288_;
        double maxY = box.f_82292_;
        double minY = box.f_82289_;
        double maxZ = box.f_82293_;
        double minZ = box.f_82290_;
        if (targetBlocks) {
            int amountX = 4 * (int)box.m_82362_();
            int amountY = 4 * (int)box.m_82376_();
            int amountZ = 4 * (int)box.m_82385_();
            Vec3 pos0 = new Vec3(minX, minY, minZ);
            Vec3 pos1 = new Vec3(maxX, minY, minZ);
            Vec3 pos2 = new Vec3(minX, minY, maxZ);
            Vec3 pos3 = new Vec3(maxX, minY, maxZ);
            Vec3 pos4 = new Vec3(minX, maxY, minZ);
            Vec3 pos5 = new Vec3(maxX, maxY, minZ);
            Vec3 pos6 = new Vec3(minX, maxY, maxZ);
            Vec3 pos7 = new Vec3(maxX, maxY, maxZ);
            LightEvents.generateParticles(pos0, center, level, size, age, 0.0, 0.0, 0.0, stats);
            LightEvents.generateParticles(pos1, center, level, size, age, 0.0, 0.0, 0.0, stats);
            LightEvents.generateParticles(pos2, center, level, size, age, 0.0, 0.0, 0.0, stats);
            LightEvents.generateParticles(pos3, center, level, size, age, 0.0, 0.0, 0.0, stats);
            LightEvents.generateParticles(pos4, center, level, size, age, 0.0, 0.0, 0.0, stats);
            LightEvents.generateParticles(pos5, center, level, size, age, 0.0, 0.0, 0.0, stats);
            LightEvents.generateParticles(pos6, center, level, size, age, 0.0, 0.0, 0.0, stats);
            LightEvents.generateParticles(pos7, center, level, size, age, 0.0, 0.0, 0.0, stats);
            LightEvents.summonParticleLine(pos0, pos1, amountX, center, level, size, age, stats);
            LightEvents.summonParticleLine(pos0, pos2, amountZ, center, level, size, age, stats);
            LightEvents.summonParticleLine(pos3, pos1, amountZ, center, level, size, age, stats);
            LightEvents.summonParticleLine(pos3, pos2, amountX, center, level, size, age, stats);
            LightEvents.summonParticleLine(pos0, pos4, amountY, center, level, size, age, stats);
            LightEvents.summonParticleLine(pos1, pos5, amountY, center, level, size, age, stats);
            LightEvents.summonParticleLine(pos2, pos6, amountY, center, level, size, age, stats);
            LightEvents.summonParticleLine(pos3, pos7, amountY, center, level, size, age, stats);
            LightEvents.summonParticleLine(pos4, pos5, amountX, center, level, size, age, stats);
            LightEvents.summonParticleLine(pos4, pos6, amountZ, center, level, size, age, stats);
            LightEvents.summonParticleLine(pos7, pos5, amountZ, center, level, size, age, stats);
            LightEvents.summonParticleLine(pos7, pos6, amountX, center, level, size, age, stats);
        } else {
            int amount = 4 * Math.max((int)box.m_82376_(), (int)box.m_82362_());
            for (int i = 0; i < amount; ++i) {
                double vec = 0.05 + 0.2 * new Random().nextDouble();
                LightEvents.generateParticles(new Vec3(maxX, center.f_82480_ - 0.5 + new Random().nextDouble(), minZ + (maxZ - minZ) * new Random().nextDouble()), center, level, size, age, 0.0, vec, 0.0, stats);
                LightEvents.generateParticles(new Vec3(minX, center.f_82480_ - 0.5 + new Random().nextDouble(), minZ + (maxZ - minZ) * new Random().nextDouble()), center, level, size, age, 0.0, vec, 0.0, stats);
                LightEvents.generateParticles(new Vec3(minX + (maxX - minX) * new Random().nextDouble(), center.f_82480_ - 0.5 + new Random().nextDouble(), minZ), center, level, size, age, 0.0, vec, 0.0, stats);
                LightEvents.generateParticles(new Vec3(minX + (maxX - minX) * new Random().nextDouble(), center.f_82480_ - 0.5 + new Random().nextDouble(), maxZ), center, level, size, age, 0.0, vec, 0.0, stats);
            }
        }
    }
}

