/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.shadowizardlib.client.particle.ember;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mindoth.shadowizardlib.client.particle.ember.ParticleColor;
import net.mindoth.shadowizardlib.registries.ModParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class ColoredDynamicTypeData
implements ParticleOptions {
    private ParticleType<ColoredDynamicTypeData> type;
    public ParticleColor color;
    float scale;
    int age;
    boolean fade;
    int renderType;
    public static final Codec<ColoredDynamicTypeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(d -> Float.valueOf(d.color.getRed())), (App)Codec.FLOAT.fieldOf("g").forGetter(d -> Float.valueOf(d.color.getGreen())), (App)Codec.FLOAT.fieldOf("b").forGetter(d -> Float.valueOf(d.color.getBlue())), (App)Codec.FLOAT.fieldOf("scale").forGetter(d -> Float.valueOf(d.scale)), (App)Codec.INT.fieldOf("age").forGetter(d -> d.age), (App)Codec.BOOL.fieldOf("fade").forGetter(d -> d.fade), (App)Codec.INT.fieldOf("mask").forGetter(d -> d.renderType)).apply((Applicative)instance, ColoredDynamicTypeData::new));
    static final ParticleOptions.Deserializer<ColoredDynamicTypeData> DESERIALIZER = new ParticleOptions.Deserializer<ColoredDynamicTypeData>(){

        public ColoredDynamicTypeData fromCommand(ParticleType<ColoredDynamicTypeData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            return new ColoredDynamicTypeData(type, ParticleColor.deserialize(reader.readString()), reader.readFloat(), reader.readInt(), reader.readBoolean(), reader.readInt());
        }

        public ColoredDynamicTypeData fromNetwork(ParticleType<ColoredDynamicTypeData> type, FriendlyByteBuf buffer) {
            return new ColoredDynamicTypeData(type, ParticleColor.deserialize(buffer.m_130277_()), buffer.readFloat(), buffer.readInt(), buffer.readBoolean(), buffer.readInt());
        }
    };

    public ParticleType<?> m_6012_() {
        return this.type;
    }

    public ColoredDynamicTypeData(float r, float g, float b, float scale, int age, boolean fade, int renderType) {
        this.type = (ParticleType)ModParticles.EMBER_TYPE.get();
        this.color = new ParticleColor(r, g, b);
        this.scale = scale;
        this.age = age;
        this.fade = fade;
        this.renderType = renderType;
    }

    public ColoredDynamicTypeData(ParticleType<ColoredDynamicTypeData> particleTypeData, ParticleColor color, float scale, int age, boolean fade, int renderType) {
        this.type = particleTypeData;
        this.color = color;
        this.scale = scale;
        this.age = age;
        this.fade = fade;
        this.renderType = renderType;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.color.serialize());
        buffer.writeFloat(this.scale);
        buffer.writeInt(this.age);
        buffer.writeBoolean(this.fade);
        buffer.writeByte(this.renderType);
    }

    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.type).toString() + " " + this.color.serialize() + " " + this.scale + " " + this.age + " " + this.fade + " " + this.renderType;
    }
}

