/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="aquaculture")
public class AquaLootTables {
    public static final ResourceLocation BOX = AquaLootTables.register("box/box");
    public static final ResourceLocation LOCKBOX = AquaLootTables.register("box/lockbox");
    public static final ResourceLocation TREASURE_CHEST = AquaLootTables.register("box/treasure_chest");
    public static final ResourceLocation NEPTUNES_BOUNTY = AquaLootTables.register("box/neptunes_bounty");
    public static final ResourceLocation FISH = AquaLootTables.register("gameplay/fishing/fish");
    public static final ResourceLocation JUNK = AquaLootTables.register("gameplay/fishing/junk");
    public static final ResourceLocation NEPTUNIUM = AquaLootTables.register("gameplay/fishing/neptunium");
    public static final ResourceLocation LAVA_FISHING = AquaLootTables.register("gameplay/fishing/lava/fishing");
    public static final ResourceLocation LAVA_FISH = AquaLootTables.register("gameplay/fishing/lava/fish");
    public static final ResourceLocation LAVA_JUNK = AquaLootTables.register("gameplay/fishing/lava/junk");
    public static final ResourceLocation LAVA_TREASURE = AquaLootTables.register("gameplay/fishing/lava/treasure");
    public static final ResourceLocation NETHER_FISHING = AquaLootTables.register("gameplay/fishing/nether/fishing");
    public static final ResourceLocation NETHER_FISH = AquaLootTables.register("gameplay/fishing/nether/fish");
    public static final ResourceLocation NETHER_JUNK = AquaLootTables.register("gameplay/fishing/nether/junk");
    public static final ResourceLocation NETHER_TREASURE = AquaLootTables.register("gameplay/fishing/nether/treasure");

    private static ResourceLocation register(String path) {
        return BuiltInLootTables.m_78769_((ResourceLocation)new ResourceLocation("aquaculture", path));
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        LootPool pool;
        ResourceLocation name = event.getName();
        if (name.equals((Object)BuiltInLootTables.f_78720_) && (pool = event.getTable().getPool("main")) != null) {
            AquaLootTables.addEntry(pool, AquaLootTables.getInjectEntry(FISH, 85, -1));
            AquaLootTables.addEntry(pool, AquaLootTables.getInjectEntry(JUNK, 10, -2));
            if (((Boolean)AquaConfig.NEPTUNIUM_OPTIONS.addNeptunesBountyToLoot.get()).booleanValue()) {
                LootPoolEntryContainer neptuniumEntry = ((LootPoolSingletonContainer.Builder)LootTableReference.m_79776_((ResourceLocation)NEPTUNIUM).m_79707_(1).m_79711_(2).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_218800_((EntitySubPredicate)FishingHookPredicate.m_39766_((boolean)true))))).m_7512_();
                AquaLootTables.addEntry(pool, neptuniumEntry);
            }
        }
    }

    private static LootPoolEntryContainer getInjectEntry(ResourceLocation location, int weight, int quality) {
        return LootTableReference.m_79776_((ResourceLocation)location).m_79707_(weight).m_79711_(quality).m_7512_();
    }

    private static void addEntry(LootPool pool, LootPoolEntryContainer entry) {
        try {
            Field entries = ObfuscationReflectionHelper.findField(LootPool.class, (String)"f_79023_");
            entries.setAccessible(true);
            LootPoolEntryContainer[] lootPoolEntriesArray = (LootPoolEntryContainer[])entries.get(pool);
            ArrayList<LootPoolEntryContainer> newLootEntries = new ArrayList<LootPoolEntryContainer>(List.of(lootPoolEntriesArray));
            if (newLootEntries.stream().anyMatch(e -> e == entry)) {
                throw new RuntimeException("Attempted to add a duplicate entry to pool: " + String.valueOf(entry));
            }
            newLootEntries.add(entry);
            LootPoolEntryContainer[] newLootEntriesArray = new LootPoolEntryContainer[newLootEntries.size()];
            newLootEntries.toArray(newLootEntriesArray);
            entries.set(pool, newLootEntriesArray);
        }
        catch (IllegalAccessException e2) {
            Aquaculture.LOG.error("Error occurred when attempting to add a new entry, to the fishing loot table");
            e2.printStackTrace();
        }
    }
}

