/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.mixin;

import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ApoliMixinPlugin
implements IMixinConfigPlugin {
    private boolean citadelLoaded;
    private boolean earsLoaded;

    private static boolean classExists(String cls) {
        try {
            Class.forName(cls, false, ApoliMixinPlugin.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void onLoad(String mixinPackage) {
        this.citadelLoaded = ApoliMixinPlugin.classExists("com.github.alexthe666.citadel.Citadel");
        this.earsLoaded = ApoliMixinPlugin.classExists("com.unascribed.ears.EarsMod");
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.equals("io.github.apace100.apoli.mixin.forge.ChangeGlowColorMixin")) {
            return !this.citadelLoaded;
        }
        if (mixinClassName.equals("io.github.apace100.apoli.mixin.forge.EarsCompatMixin")) {
            return this.earsLoaded;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

