/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.util;

import com.google.common.util.concurrent.Futures;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.util.ApoliConfigs;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.ApoliCommon;
import io.github.edwinmindcraft.apoli.common.network.S2CCachedSpawnsPacket;
import io.github.edwinmindcraft.apoli.common.network.S2CResetSpawnCachePacket;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyPlayerSpawnConfiguration;
import io.github.edwinmindcraft.apoli.common.util.SpawnLookupUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class SpawnLookupScheduler {
    public static final SpawnLookupScheduler INSTANCE = new SpawnLookupScheduler();
    private static final Executor EXECUTOR = Executors.newSingleThreadExecutor();
    private final HashMap<ResourceKey<ConfiguredPower<?, ?>>, CompletionTracker> trackers = new HashMap();
    private final Object2IntMap<ResourceKey<ConfiguredPower<?, ?>>> powers = new Object2IntOpenHashMap();
    private final HashSet<ResourceKey<ConfiguredPower<?, ?>>> handled = new HashSet();
    private boolean isRunning = false;

    private SpawnLookupScheduler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> requestSpawn(ResourceKey<ConfiguredPower<?, ?>> power) {
        if (!((Boolean)ApoliConfigs.SERVER.separateSpawnFindingThread.get()).booleanValue()) {
            if (!SpawnLookupUtil.hasSpawnCached(power)) {
                this.doSpawnLookup(power);
            }
            return Futures.immediateVoidFuture();
        }
        SpawnLookupScheduler spawnLookupScheduler = this;
        synchronized (spawnLookupScheduler) {
            CompletionTracker result;
            if (this.handled.contains(power)) {
                return Futures.immediateVoidFuture();
            }
            this.powers.compute(power, (key, oldValue) -> oldValue != null ? oldValue + 1 : 0);
            HashMap<ResourceKey<ConfiguredPower<?, ?>>, CompletionTracker> hashMap = this.trackers;
            synchronized (hashMap) {
                result = this.trackers.computeIfAbsent(power, i -> new CompletionTracker());
            }
            if (!this.isRunning) {
                this.isRunning = true;
                this.queueNext();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionTracker getTracker(ResourceKey<ConfiguredPower<?, ?>> power) {
        HashMap<ResourceKey<ConfiguredPower<?, ?>>, CompletionTracker> hashMap = this.trackers;
        synchronized (hashMap) {
            return this.trackers.computeIfAbsent(power, i -> new CompletionTracker());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueNext() {
        SpawnLookupScheduler spawnLookupScheduler = this;
        synchronized (spawnLookupScheduler) {
            Optional<ResourceKey> next = this.powers.object2IntEntrySet().stream().max(Comparator.comparingInt(Object2IntMap.Entry::getIntValue)).map(Map.Entry::getKey);
            if (next.isEmpty()) {
                this.isRunning = false;
                return;
            }
            ResourceKey power = next.get();
            this.handled.add(power);
            this.powers.removeInt((Object)power);
            CompletableFuture.runAsync(() -> this.doSpawnLookup(power), EXECUTOR).thenRun(this::queueNext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(ResourceKey<ConfiguredPower<?, ?>> power) {
        SpawnLookupScheduler spawnLookupScheduler = this;
        synchronized (spawnLookupScheduler) {
            this.handled.remove(power);
            SpawnLookupUtil.clearSpawnCacheValue(power);
            ApoliCommon.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CCachedSpawnsPacket(Set.of(power), true));
            this.powers.compute(power, (key, oldValue) -> oldValue != null ? oldValue : 0);
            if (!this.isRunning) {
                this.isRunning = true;
                this.queueNext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws InterruptedException {
        SpawnLookupScheduler spawnLookupScheduler = this;
        synchronized (spawnLookupScheduler) {
            this.powers.clear();
            this.handled.clear();
        }
        while (true) {
            boolean flag;
            SpawnLookupScheduler spawnLookupScheduler2 = this;
            synchronized (spawnLookupScheduler2) {
                flag = this.isRunning;
            }
            if (!flag) break;
            Thread.sleep(50L);
        }
        SpawnLookupScheduler spawnLookupScheduler3 = this;
        synchronized (spawnLookupScheduler3) {
            this.powers.clear();
            this.handled.clear();
        }
        SpawnLookupUtil.resetSpawnCache();
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return;
        }
        ApoliCommon.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CResetSpawnCachePacket());
    }

    public void doSpawnLookup(ResourceKey<ConfiguredPower<?, ?>> power) {
        this.handlePower(power);
        CompletionTracker tracker = this.getTracker(power);
        if (tracker != null) {
            tracker.complete();
        }
    }

    private void handlePower(ResourceKey<ConfiguredPower<?, ?>> power) {
        ConfiguredPower configuredPower = (ConfiguredPower)ApoliAPI.getPowers().m_6246_(power);
        Object c = configuredPower.getConfiguration();
        if (c instanceof ModifyPlayerSpawnConfiguration) {
            ModifyPlayerSpawnConfiguration configuration = (ModifyPlayerSpawnConfiguration)c;
            ServerLevel targetDimension = ServerLifecycleHooks.getCurrentServer().m_129880_(configuration.dimension());
            if (targetDimension == null) {
                Apoli.LOGGER.warn("Power {} could not set spawnpoint at dimension \"{}\" as it's not registered! Falling back to default spawnpoint...", (Object)power.m_135782_(), (Object)configuration.dimension().m_135782_());
                this.handleFailure(power);
                return;
            }
            BlockPos regularSpawn = Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_)).m_220360_();
            int center = targetDimension.m_143344_() / 2;
            int range = 64;
            AtomicReference modifiedSpawnPos = new AtomicReference();
            BlockPos.MutableBlockPos modifiedSpawnBlockPos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos dimensionSpawnPos = configuration.strategy().apply(regularSpawn, center, configuration.distanceMultiplier()).m_122032_();
            configuration.getBiomePos(power.m_135782_(), targetDimension, (BlockPos)dimensionSpawnPos).ifPresent(arg_0 -> ((BlockPos.MutableBlockPos)dimensionSpawnPos).m_122190_(arg_0));
            configuration.getSpawnPos(power.m_135782_(), targetDimension, (BlockPos)dimensionSpawnPos, range).ifPresent(modifiedSpawnPos::set);
            if (modifiedSpawnPos.get() == null) {
                this.handleFailure(power);
                return;
            }
            Vec3 msp = (Vec3)modifiedSpawnPos.get();
            modifiedSpawnBlockPos.m_122169_(msp.f_82479_, msp.f_82480_, msp.f_82481_);
            SpawnLookupUtil.changeSpawnCacheValue(power, targetDimension, msp);
            SpawnLookupUtil.addToPowersWithSpawns(power);
            ApoliCommon.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CCachedSpawnsPacket(Set.of(power)));
        } else {
            this.handleFailure(power);
        }
    }

    private void handleFailure(ResourceKey<ConfiguredPower<?, ?>> power) {
        SpawnLookupUtil.emptySpawnCacheValue(power);
        SpawnLookupUtil.addToPowersWithSpawns(power);
        ApoliCommon.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CCachedSpawnsPacket(Set.of(power)));
    }

    private static class CompletionTracker
    implements Future<Void> {
        private boolean isComplete;

        private CompletionTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete() {
            CompletionTracker completionTracker = this;
            synchronized (completionTracker) {
                this.isComplete = true;
                this.notifyAll();
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            CompletionTracker completionTracker = this;
            synchronized (completionTracker) {
                return this.isComplete;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void get() throws InterruptedException {
            while (true) {
                CompletionTracker completionTracker = this;
                synchronized (completionTracker) {
                    if (this.isComplete) {
                        return null;
                    }
                }
                this.wait(1000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, TimeoutException {
            long end = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, unit);
            while (true) {
                CompletionTracker completionTracker = this;
                synchronized (completionTracker) {
                    if (this.isComplete) {
                        return null;
                    }
                }
                if (end >= System.currentTimeMillis()) {
                    throw new TimeoutException();
                }
                this.wait(Math.min(1000L, end - System.currentTimeMillis()));
            }
        }
    }
}

