/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.util;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyDamageDealtPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyDamageTakenPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyDamageDealtConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyDamageTakenConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;

public interface LivingDamageCache {
    public List<Holder<ConfiguredPower<ModifyDamageTakenConfiguration, ModifyDamageTakenPower>>> getModifyDamageTakenPowers();

    public List<Holder<ConfiguredPower<ModifyDamageDealtConfiguration, ModifyDamageDealtPower>>> getModifyDamageDealtPowers();

    public void setModifyDamageTakenPowers(List<Holder<ConfiguredPower<ModifyDamageTakenConfiguration, ModifyDamageTakenPower>>> var1);

    public void setModifyDamageDealtPowers(List<Holder<ConfiguredPower<ModifyDamageDealtConfiguration, ModifyDamageDealtPower>>> var1);

    public void bypassDamageCheck(boolean var1);

    public boolean bypassesDamageCheck();

    public void setArmorValues(int var1, int var2);

    default public void gatherDamagePowers(Entity entity, DamageSource source, float amount) {
        this.setModifyDamageTakenPowers(IPowerContainer.getPowers(entity, (ModifyDamageTakenPower)ApoliPowers.MODIFY_DAMAGE_TAKEN.get(), x -> ((ConfiguredPower)x.m_203334_()).isActive(entity) && ((ModifyDamageTakenPower)((ConfiguredPower)x.m_203334_()).getFactory()).check((ConfiguredPower)x.m_203334_(), entity, source, amount)));
        ModifyDamageDealtPower dealtFactory = source.m_269533_(DamageTypeTags.f_268524_) ? (ModifyDamageDealtPower)ApoliPowers.MODIFY_PROJECTILE_DAMAGE.get() : (ModifyDamageDealtPower)ApoliPowers.MODIFY_DAMAGE_DEALT.get();
        this.setModifyDamageDealtPowers(IPowerContainer.getPowers(source.m_7639_(), dealtFactory, x -> ((ConfiguredPower)x.m_203334_()).isActive(Objects.requireNonNull(source.m_7639_())) && dealtFactory.check((ConfiguredPower)x.m_203334_(), Objects.requireNonNull(source.m_7639_()), entity, source, amount)));
        this.bypassDamageCheck(false);
        int apply = 0;
        int damage = 0;
        for (Holder<ConfiguredPower<ModifyDamageTakenConfiguration, ModifyDamageTakenPower>> holder : this.getModifyDamageTakenPowers()) {
            ConfiguredPower power = (ConfiguredPower)holder.m_203334_();
            ModifyDamageTakenPower factory = (ModifyDamageTakenPower)power.getFactory();
            if (factory.modifiesArmorApplicance(power)) {
                apply = factory.checkArmorApplicance(power, entity) ? ++apply : --apply;
            }
            if (!factory.modifiesArmorDamaging(power)) continue;
            if (factory.checkArmorDamaging(power, entity)) {
                ++damage;
                continue;
            }
            --damage;
        }
        this.setArmorValues(apply, damage);
    }
}

