/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.util;

import com.mojang.datafixers.util.Pair;
import io.github.apace100.apoli.access.ModifiableFoodEntity;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.power.DummyPower;
import io.github.edwinmindcraft.apoli.common.power.ElytraFlightPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyFoodPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyHarvestPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyValueBlockPower;
import io.github.edwinmindcraft.apoli.common.power.RestrictArmorPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyFoodConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyValueBlockConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class CoreUtils {
    public static boolean isItemForbidden(Entity entity, EquipmentSlot slot, ItemStack stack) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        return RestrictArmorPower.isForbidden((Entity)living, slot, stack) || stack.m_150930_(Items.f_42741_) && IPowerContainer.hasPower((Entity)living, (ElytraFlightPower)ApoliPowers.ELYTRA_FLIGHT.get());
    }

    public static float modifyFriction(float friction, LevelReader level, BlockPos pos, @Nullable Entity entity, BlockState state) {
        if (entity != null) {
            return IPowerContainer.modify(entity, (ModifyValueBlockPower)ApoliPowers.MODIFY_SLIPPERINESS.get(), friction, p -> ConfiguredBlockCondition.check(((ModifyValueBlockConfiguration)((ConfiguredPower)p.m_203334_()).getConfiguration()).condition(), level, pos, (NonNullSupplier<BlockState>)((NonNullSupplier)() -> state)));
        }
        return friction;
    }

    public static int allowHarvest(BlockGetter level, BlockPos pos, Player player) {
        if (level instanceof LevelReader) {
            LevelReader reader = (LevelReader)level;
            return ModifyHarvestPower.isHarvestAllowed(player, reader, pos).map(x -> x != false ? 1 : 0).orElse(-1);
        }
        return -1;
    }

    private static FoodProperties applyTranformations(LivingEntity living, FoodProperties original, List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> powers, Runnable syncAction) {
        if (powers.isEmpty()) {
            return original;
        }
        LinkedList food = new LinkedList();
        LinkedList saturation = new LinkedList();
        for (ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower> power : powers) {
            food.addAll(power.getConfiguration().foodModifiers().getContent());
            saturation.addAll(power.getConfiguration().saturationModifiers().getContent());
        }
        int originalNutrition = original == null ? 0 : original.m_38744_();
        float originalSaturation = original == null ? 0.0f : original.m_38745_();
        int nutrition = (int)ModifierUtil.applyModifiers((Entity)living, food, (double)originalNutrition);
        float saturationMod = (float)ModifierUtil.applyModifiers((Entity)living, saturation, (double)originalSaturation);
        FoodProperties.Builder builder = new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturationMod);
        if (nutrition != originalNutrition && nutrition == 0 || saturationMod != originalSaturation && saturationMod == 0.0f) {
            syncAction.run();
        }
        if (original != null && original.m_38747_() || powers.stream().anyMatch(x -> ((ModifyFoodConfiguration)x.getConfiguration()).alwaysEdible())) {
            builder.m_38765_();
        }
        if (original != null) {
            if (powers.stream().noneMatch(x -> ((ModifyFoodConfiguration)x.getConfiguration()).preventEffects())) {
                original.m_38749_().forEach(pair -> builder.effect(() -> ((Pair)pair).getFirst(), ((Float)pair.getSecond()).floatValue()));
            }
            if (original.m_38748_()) {
                builder.m_38766_();
            }
            if (original.m_38746_()) {
                builder.m_38757_();
            }
        }
        return builder.m_38767_();
    }

    public static FoodProperties transformFoodProperties(FoodProperties original, ItemStack stack, LivingEntity living) {
        ModifiableFoodEntity mfe;
        if (living instanceof ModifiableFoodEntity && (mfe = (ModifiableFoodEntity)living).getCurrentModifyFoodPowers() != null) {
            List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> powers = mfe.getCurrentModifyFoodPowers();
            return CoreUtils.applyTranformations(living, original, powers, mfe::enforceFoodSync);
        }
        return original;
    }

    public static boolean shouldIgnoreWater(LivingEntity living, FluidState state) {
        return IPowerContainer.hasPower((Entity)living, (DummyPower)ApoliPowers.IGNORE_WATER.get()) && state.getFluidType() == ForgeMod.WATER_TYPE.get();
    }
}

