/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.util;

import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.apace100.apoli.util.ApoliResourceConditions;
import io.github.edwinmindcraft.calio.common.registry.CalioDynamicRegistryManager;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class AnyNamespacesLoadedCondition
implements ICondition {
    private final String[] namespaces;

    public AnyNamespacesLoadedCondition(Collection<String> namespaces) {
        this.namespaces = (String[])namespaces.toArray(String[]::new);
    }

    public ResourceLocation getID() {
        return ApoliResourceConditions.ANY_NAMESPACE_LOADED;
    }

    public boolean test(ICondition.IContext context) {
        for (String namespace : this.namespaces) {
            if (!CalioDynamicRegistryManager.LOADED_NAMESPACES.contains(namespace)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "apoli:any_namespace_loaded(\"" + Joiner.on((String)", ").join((Object[])this.namespaces) + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<AnyNamespacesLoadedCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, AnyNamespacesLoadedCondition value) {
            JsonArray values = new JsonArray();
            for (String namespace : value.namespaces) {
                values.add(namespace);
            }
            json.add("namespaces", (JsonElement)values);
        }

        public AnyNamespacesLoadedCondition read(JsonObject json) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"namespaces");
            HashSet<String> namespaces = new HashSet<String>();
            for (JsonElement element : array) {
                if (element.isJsonPrimitive()) {
                    namespaces.add(element.getAsString());
                    continue;
                }
                throw new JsonParseException("Invalid " + element + " entry: expected a JSON string!");
            }
            return new AnyNamespacesLoadedCondition(namespaces);
        }

        public ResourceLocation getID() {
            return ApoliResourceConditions.ANY_NAMESPACE_LOADED;
        }
    }
}

