/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.registry.condition;

import io.github.apace100.apoli.Apoli;
import io.github.edwinmindcraft.apoli.api.MetaFactories;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.ItemCondition;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.condition.item.ComparingItemCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.DelegatedItemCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.EnchantmentCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.FloatComparingItemCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.IngredientCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.IntComparingItemCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.IsEquippableCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.ItemHasPowerCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.NbtCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.PowerCountCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.SimpleItemCondition;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConditionStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConstantConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRegisters;
import java.util.Arrays;
import java.util.function.BiPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class ApoliItemConditions {
    public static final BiPredicate<ConfiguredItemCondition<?, ?>, Pair<Level, ItemStack>> PREDICATE = (config, pair) -> config.check((Level)pair.getKey(), (ItemStack)pair.getValue());
    public static final RegistryObject<DelegatedItemCondition<ConstantConfiguration<Pair<Level, ItemStack>>>> CONSTANT = ApoliItemConditions.of("constant");
    public static final RegistryObject<DelegatedItemCondition<ConditionStreamConfiguration<ConfiguredItemCondition<?, ?>, Pair<Level, ItemStack>>>> AND = ApoliItemConditions.of("and");
    public static final RegistryObject<DelegatedItemCondition<ConditionStreamConfiguration<ConfiguredItemCondition<?, ?>, Pair<Level, ItemStack>>>> OR = ApoliItemConditions.of("or");
    public static final RegistryObject<SimpleItemCondition> FOOD = ApoliRegisters.ITEM_CONDITIONS.register("food", () -> new SimpleItemCondition(ItemStack::m_41614_));
    public static final RegistryObject<SimpleItemCondition> MEAT = ApoliRegisters.ITEM_CONDITIONS.register("meat", () -> new SimpleItemCondition(stack -> stack.m_41614_() && stack.m_41720_().m_41473_() != null && stack.m_41720_().m_41473_().m_38746_()));
    public static final RegistryObject<IngredientCondition> INGREDIENT = ApoliRegisters.ITEM_CONDITIONS.register("ingredient", IngredientCondition::new);
    public static final RegistryObject<ComparingItemCondition> ARMOR_VALUE = ApoliRegisters.ITEM_CONDITIONS.register("armor_value", () -> new ComparingItemCondition(value -> {
        int n;
        Item patt2784$temp = value.m_41720_();
        if (patt2784$temp instanceof ArmorItem) {
            ArmorItem ai = (ArmorItem)patt2784$temp;
            n = ai.m_40404_();
        } else {
            n = 0;
        }
        return n;
    }));
    public static final RegistryObject<ComparingItemCondition> HARVEST_LEVEL = ApoliRegisters.ITEM_CONDITIONS.register("harvest_level", () -> new ComparingItemCondition(value -> {
        int n;
        Item patt3010$temp = value.m_41720_();
        if (patt3010$temp instanceof DiggerItem) {
            DiggerItem ti = (DiggerItem)patt3010$temp;
            n = ti.m_43314_().m_6604_();
        } else {
            n = 0;
        }
        return n;
    }));
    public static final RegistryObject<EnchantmentCondition> ENCHANTMENT = ApoliRegisters.ITEM_CONDITIONS.register("enchantment", EnchantmentCondition::new);
    public static final RegistryObject<NbtCondition> NBT = ApoliRegisters.ITEM_CONDITIONS.register("nbt", NbtCondition::new);
    public static final RegistryObject<SimpleItemCondition> FIREPROOF = ApoliRegisters.ITEM_CONDITIONS.register("fireproof", () -> new SimpleItemCondition(x -> x.m_41720_().m_41475_()));
    public static final RegistryObject<SimpleItemCondition> ENCHANTABLE = ApoliRegisters.ITEM_CONDITIONS.register("enchantable", () -> new SimpleItemCondition(ItemStack::m_41792_));
    public static final RegistryObject<SimpleItemCondition> EMPTY = ApoliRegisters.ITEM_CONDITIONS.register("empty", () -> new SimpleItemCondition(ItemStack::m_41619_));
    public static final RegistryObject<IntComparingItemCondition> AMOUNT = ApoliRegisters.ITEM_CONDITIONS.register("amount", () -> new IntComparingItemCondition(ItemStack::m_41613_));
    public static final RegistryObject<PowerCountCondition> POWER_COUNT = ApoliRegisters.ITEM_CONDITIONS.register("power_count", PowerCountCondition::new);
    public static final RegistryObject<ItemHasPowerCondition> HAS_POWER = ApoliRegisters.ITEM_CONDITIONS.register("has_power", ItemHasPowerCondition::new);
    public static final RegistryObject<SimpleItemCondition> SMELTABLE = ApoliRegisters.ITEM_CONDITIONS.register("smeltable", () -> new SimpleItemCondition((level, stack) -> SimpleItemCondition.forCookingRecipeType(level, stack, (RecipeType<? extends AbstractCookingRecipe>)RecipeType.f_44108_)));
    public static final RegistryObject<SimpleItemCondition> IS_DAMAGEABLE = ApoliRegisters.ITEM_CONDITIONS.register("is_damageable", () -> new SimpleItemCondition(ItemStack::m_41763_));
    public static final RegistryObject<IntComparingItemCondition> DURABILITY = ApoliRegisters.ITEM_CONDITIONS.register("durability", () -> new IntComparingItemCondition(stack -> stack.m_41776_() - stack.m_41773_()));
    public static final RegistryObject<FloatComparingItemCondition> RELATIVE_DURABILITY = ApoliRegisters.ITEM_CONDITIONS.register("relative_durability", () -> new FloatComparingItemCondition(stack -> Float.valueOf((float)(stack.m_41776_() - stack.m_41773_()) / (float)stack.m_41776_())));
    public static final RegistryObject<IsEquippableCondition> IS_EQUIPPABLE = ApoliRegisters.ITEM_CONDITIONS.register("is_equippable", IsEquippableCondition::new);

    private static <U extends ItemCondition<?>> RegistryObject<U> of(String name) {
        return RegistryObject.create((ResourceLocation)Apoli.identifier(name), (ResourceLocation)ApoliRegistries.ITEM_CONDITION_KEY.m_135782_(), (String)"apoli");
    }

    public static ConfiguredItemCondition<?, ?> constant(boolean value) {
        return (ConfiguredItemCondition)((DelegatedItemCondition)CONSTANT.get()).configure(new ConstantConfiguration(value));
    }

    @SafeVarargs
    public static ConfiguredItemCondition<?, ?> and(HolderSet<ConfiguredItemCondition<?, ?>> ... conditions) {
        return (ConfiguredItemCondition)((DelegatedItemCondition)AND.get()).configure(ConditionStreamConfiguration.and(Arrays.asList(conditions), PREDICATE));
    }

    public static ConfiguredItemCondition<?, ?> and(ConfiguredItemCondition<?, ?> ... conditions) {
        return ApoliItemConditions.and(new HolderSet[]{HolderSet.m_205806_(Holder::m_205709_, (Object[])conditions)});
    }

    @SafeVarargs
    public static ConfiguredItemCondition<?, ?> or(HolderSet<ConfiguredItemCondition<?, ?>> ... conditions) {
        return (ConfiguredItemCondition)((DelegatedItemCondition)OR.get()).configure(ConditionStreamConfiguration.or(Arrays.asList(conditions), PREDICATE));
    }

    public static void bootstrap() {
        MetaFactories.defineMetaConditions(ApoliRegisters.ITEM_CONDITIONS, DelegatedItemCondition::new, ConfiguredItemCondition.CODEC_SET, PREDICATE);
    }
}

