/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.registry.condition;

import io.github.apace100.apoli.Apoli;
import io.github.edwinmindcraft.apoli.api.MetaFactories;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredDamageCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.DamageCondition;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.condition.damage.AmountCondition;
import io.github.edwinmindcraft.apoli.common.condition.damage.AttackerCondition;
import io.github.edwinmindcraft.apoli.common.condition.damage.DelegatedDamageCondition;
import io.github.edwinmindcraft.apoli.common.condition.damage.InTagCondition;
import io.github.edwinmindcraft.apoli.common.condition.damage.NameCondition;
import io.github.edwinmindcraft.apoli.common.condition.damage.ProjectileCondition;
import io.github.edwinmindcraft.apoli.common.condition.damage.SimpleDamageCondition;
import io.github.edwinmindcraft.apoli.common.condition.damage.SimpleTagCondition;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConditionStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConstantConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRegisters;
import java.util.Arrays;
import java.util.function.BiPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class ApoliDamageConditions {
    public static final BiPredicate<ConfiguredDamageCondition<?, ?>, Pair<DamageSource, Float>> PREDICATE = (config, pair) -> config.check((DamageSource)pair.getLeft(), ((Float)pair.getRight()).floatValue());
    public static final RegistryObject<DelegatedDamageCondition<ConstantConfiguration<Pair<DamageSource, Float>>>> CONSTANT = ApoliDamageConditions.of("constant");
    public static final RegistryObject<DelegatedDamageCondition<ConditionStreamConfiguration<ConfiguredDamageCondition<?, ?>, Pair<DamageSource, Float>>>> AND = ApoliDamageConditions.of("and");
    public static final RegistryObject<DelegatedDamageCondition<ConditionStreamConfiguration<ConfiguredDamageCondition<?, ?>, Pair<DamageSource, Float>>>> OR = ApoliDamageConditions.of("or");
    public static final RegistryObject<AmountCondition> AMOUNT = ApoliRegisters.DAMAGE_CONDITIONS.register("amount", AmountCondition::new);
    public static final RegistryObject<NameCondition> NAME = ApoliRegisters.DAMAGE_CONDITIONS.register("name", NameCondition::new);
    public static final RegistryObject<InTagCondition> IN_TAG = ApoliRegisters.DAMAGE_CONDITIONS.register("in_tag", InTagCondition::new);
    public static final RegistryObject<SimpleDamageCondition> FIRE = ApoliRegisters.DAMAGE_CONDITIONS.register("fire", () -> new SimpleTagCondition((TagKey<DamageType>)DamageTypeTags.f_268745_));
    public static final RegistryObject<ProjectileCondition> PROJECTILE = ApoliRegisters.DAMAGE_CONDITIONS.register("projectile", ProjectileCondition::new);
    public static final RegistryObject<AttackerCondition> ATTACKER = ApoliRegisters.DAMAGE_CONDITIONS.register("attacker", AttackerCondition::new);
    public static final RegistryObject<SimpleDamageCondition> BYPASSES_ARMOR = ApoliRegisters.DAMAGE_CONDITIONS.register("bypasses_armor", () -> new SimpleTagCondition((TagKey<DamageType>)DamageTypeTags.f_268490_));
    public static final RegistryObject<SimpleDamageCondition> EXPLOSIVE = ApoliRegisters.DAMAGE_CONDITIONS.register("explosive", () -> new SimpleTagCondition((TagKey<DamageType>)DamageTypeTags.f_268415_));
    public static final RegistryObject<SimpleDamageCondition> FROM_FALLING = ApoliRegisters.DAMAGE_CONDITIONS.register("from_falling", () -> new SimpleTagCondition((TagKey<DamageType>)DamageTypeTags.f_268549_));
    public static final RegistryObject<SimpleDamageCondition> UNBLOCKABLE = ApoliRegisters.DAMAGE_CONDITIONS.register("unblockable", () -> new SimpleTagCondition((TagKey<DamageType>)DamageTypeTags.f_276146_));
    public static final RegistryObject<SimpleDamageCondition> OUT_OF_WORLD = ApoliRegisters.DAMAGE_CONDITIONS.register("out_of_world", () -> new SimpleTagCondition((TagKey<DamageType>)DamageTypeTags.f_268738_));

    private static <U extends DamageCondition<?>> RegistryObject<U> of(String name) {
        return RegistryObject.create((ResourceLocation)Apoli.identifier(name), (ResourceLocation)ApoliRegistries.DAMAGE_CONDITION_KEY.m_135782_(), (String)"apoli");
    }

    public static ConfiguredDamageCondition<?, ?> constant(boolean value) {
        return (ConfiguredDamageCondition)((DelegatedDamageCondition)CONSTANT.get()).configure(new ConstantConfiguration(value));
    }

    @SafeVarargs
    public static ConfiguredDamageCondition<?, ?> and(HolderSet<ConfiguredDamageCondition<?, ?>> ... conditions) {
        return (ConfiguredDamageCondition)((DelegatedDamageCondition)AND.get()).configure(ConditionStreamConfiguration.and(Arrays.asList(conditions), PREDICATE));
    }

    @SafeVarargs
    public static ConfiguredDamageCondition<?, ?> or(HolderSet<ConfiguredDamageCondition<?, ?>> ... conditions) {
        return (ConfiguredDamageCondition)((DelegatedDamageCondition)OR.get()).configure(ConditionStreamConfiguration.or(Arrays.asList(conditions), PREDICATE));
    }

    public static void bootstrap() {
        MetaFactories.defineMetaConditions(ApoliRegisters.DAMAGE_CONDITIONS, DelegatedDamageCondition::new, ConfiguredDamageCondition.CODEC_SET, PREDICATE);
    }
}

