/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.registry.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.factory.condition.DistanceFromCoordinatesConditionRegistry;
import io.github.apace100.apoli.power.factory.condition.block.MaterialCondition;
import io.github.edwinmindcraft.apoli.api.MetaFactories;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.BlockCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.context.BlockConditionContext;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.condition.block.AdjacentCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.AttachableCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.BlockStateCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.BlockTypeCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.DelegatedBlockCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.FloatComparingBlockCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.FluidBlockCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.HeightCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.InTagBlockCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.LightLevelCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.NbtCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.OffsetCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.SimpleBlockCondition;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConditionStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConstantConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRegisters;
import java.util.Arrays;
import java.util.function.BiPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public class ApoliBlockConditions {
    public static final BiPredicate<ConfiguredBlockCondition<?, ?>, BlockConditionContext> PREDICATE = (config, context) -> config.check(context.reader(), context.position(), context.stateGetter());
    public static final RegistryObject<DelegatedBlockCondition<ConstantConfiguration<BlockConditionContext>>> CONSTANT = ApoliBlockConditions.of("constant");
    public static final RegistryObject<DelegatedBlockCondition<ConditionStreamConfiguration<ConfiguredBlockCondition<?, ?>, BlockConditionContext>>> AND = ApoliBlockConditions.of("and");
    public static final RegistryObject<DelegatedBlockCondition<ConditionStreamConfiguration<ConfiguredBlockCondition<?, ?>, BlockConditionContext>>> OR = ApoliBlockConditions.of("or");
    public static final RegistryObject<SimpleBlockCondition> MOVEMENT_BLOCKING = ApoliRegisters.BLOCK_CONDITIONS.register("movement_blocking", () -> new SimpleBlockCondition(SimpleBlockCondition.MOVEMENT_BLOCKING));
    public static final RegistryObject<SimpleBlockCondition> REPLACEABLE_LEGACY = ApoliRegisters.BLOCK_CONDITIONS.register("replacable", () -> new SimpleBlockCondition(SimpleBlockCondition.REPLACEABLE));
    public static final RegistryObject<SimpleBlockCondition> REPLACEABLE = ApoliRegisters.BLOCK_CONDITIONS.register("replaceable", () -> new SimpleBlockCondition(SimpleBlockCondition.REPLACEABLE));
    public static final RegistryObject<SimpleBlockCondition> LIGHT_BLOCKING = ApoliRegisters.BLOCK_CONDITIONS.register("light_blocking", () -> new SimpleBlockCondition(SimpleBlockCondition.LIGHT_BLOCKING));
    public static final RegistryObject<SimpleBlockCondition> WATER_LOGGABLE = ApoliRegisters.BLOCK_CONDITIONS.register("water_loggable", () -> new SimpleBlockCondition(SimpleBlockCondition.WATER_LOGGABLE));
    public static final RegistryObject<SimpleBlockCondition> EXPOSED_TO_SKY = ApoliRegisters.BLOCK_CONDITIONS.register("exposed_to_sky", () -> new SimpleBlockCondition(SimpleBlockCondition.EXPOSED_TO_SKY));
    public static final RegistryObject<InTagBlockCondition> IN_TAG = ApoliRegisters.BLOCK_CONDITIONS.register("in_tag", InTagBlockCondition::new);
    public static final RegistryObject<FluidBlockCondition> FLUID = ApoliRegisters.BLOCK_CONDITIONS.register("fluid", FluidBlockCondition::new);
    public static final RegistryObject<OffsetCondition> OFFSET = ApoliRegisters.BLOCK_CONDITIONS.register("offset", OffsetCondition::new);
    public static final RegistryObject<AttachableCondition> ATTACHABLE = ApoliRegisters.BLOCK_CONDITIONS.register("attachable", AttachableCondition::new);
    public static final RegistryObject<BlockTypeCondition> BLOCK = ApoliRegisters.BLOCK_CONDITIONS.register("block", BlockTypeCondition::new);
    public static final RegistryObject<AdjacentCondition> ADJACENT = ApoliRegisters.BLOCK_CONDITIONS.register("adjacent", AdjacentCondition::new);
    public static final RegistryObject<LightLevelCondition> LIGHT_LEVEL = ApoliRegisters.BLOCK_CONDITIONS.register("light_level", LightLevelCondition::new);
    public static final RegistryObject<BlockStateCondition> BLOCK_STATE = ApoliRegisters.BLOCK_CONDITIONS.register("block_state", BlockStateCondition::new);
    public static final RegistryObject<HeightCondition> HEIGHT = ApoliRegisters.BLOCK_CONDITIONS.register("height", HeightCondition::new);
    public static final RegistryObject<MaterialCondition> MATERIAL = ApoliRegisters.BLOCK_CONDITIONS.register("material", MaterialCondition::new);
    public static final RegistryObject<SimpleBlockCondition> BLOCK_ENTITY = ApoliRegisters.BLOCK_CONDITIONS.register("block_entity", () -> new SimpleBlockCondition(SimpleBlockCondition.BLOCK_ENTITY));
    public static final RegistryObject<FloatComparingBlockCondition> SLIPPERINESS = ApoliRegisters.BLOCK_CONDITIONS.register("slipperiness", () -> new FloatComparingBlockCondition((level, pos, stateGetter) -> ((BlockState)stateGetter.get()).getFriction(level, pos, null)));
    public static final RegistryObject<FloatComparingBlockCondition> BLAST_RESISTANCE = ApoliRegisters.BLOCK_CONDITIONS.register("blast_resistance", () -> new FloatComparingBlockCondition((level, pos, stateGetter) -> ((BlockState)stateGetter.get()).m_60734_().m_7325_()));
    public static final RegistryObject<FloatComparingBlockCondition> HARDNESS = ApoliRegisters.BLOCK_CONDITIONS.register("hardness", () -> new FloatComparingBlockCondition((level, pos, stateGetter) -> ((BlockState)stateGetter.get()).m_60800_((BlockGetter)level, pos)));
    public static final RegistryObject<NbtCondition> NBT = ApoliRegisters.BLOCK_CONDITIONS.register("nbt", NbtCondition::new);

    private static <U extends BlockCondition<?>> RegistryObject<U> of(String name) {
        return RegistryObject.create((ResourceLocation)Apoli.identifier(name), (ResourceLocation)ApoliRegistries.BLOCK_CONDITION_KEY.m_135782_(), (String)"apoli");
    }

    public static ConfiguredBlockCondition<?, ?> constant(boolean value) {
        return (ConfiguredBlockCondition)((DelegatedBlockCondition)CONSTANT.get()).configure(new ConstantConfiguration(value));
    }

    @SafeVarargs
    public static ConfiguredBlockCondition<?, ?> and(HolderSet<ConfiguredBlockCondition<?, ?>> ... conditions) {
        return (ConfiguredBlockCondition)((DelegatedBlockCondition)AND.get()).configure(ConditionStreamConfiguration.and(Arrays.asList(conditions), PREDICATE));
    }

    @SafeVarargs
    public static ConfiguredBlockCondition<?, ?> or(HolderSet<ConfiguredBlockCondition<?, ?>> ... conditions) {
        return (ConfiguredBlockCondition)((DelegatedBlockCondition)OR.get()).configure(ConditionStreamConfiguration.or(Arrays.asList(conditions), PREDICATE));
    }

    public static void bootstrap() {
        MetaFactories.defineMetaConditions(ApoliRegisters.BLOCK_CONDITIONS, DelegatedBlockCondition::new, ConfiguredBlockCondition.CODEC_SET, PREDICATE);
        DistanceFromCoordinatesConditionRegistry.registerBlockConditions();
    }
}

