/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.registry.condition;

import com.mojang.serialization.Codec;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.edwinmindcraft.apoli.api.MetaFactories;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiomeCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.BiomeCondition;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.condition.biome.CategoryBiomeCondition;
import io.github.edwinmindcraft.apoli.common.condition.biome.DelegatedBiomeCondition;
import io.github.edwinmindcraft.apoli.common.condition.biome.FloatComparingBiomeCondition;
import io.github.edwinmindcraft.apoli.common.condition.biome.HighHumidityCondition;
import io.github.edwinmindcraft.apoli.common.condition.biome.InTagCondition;
import io.github.edwinmindcraft.apoli.common.condition.biome.PropertyBiomeCondition;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConditionStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConstantConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRegisters;
import java.util.Arrays;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.RegistryObject;

public class ApoliBiomeConditions {
    public static final BiPredicate<ConfiguredBiomeCondition<?, ?>, Holder<Biome>> PREDICATE = ConfiguredBiomeCondition::check;
    public static final RegistryObject<DelegatedBiomeCondition<ConstantConfiguration<Holder<Biome>>>> CONSTANT = ApoliBiomeConditions.of("constant");
    public static final RegistryObject<DelegatedBiomeCondition<ConditionStreamConfiguration<ConfiguredBiomeCondition<?, ?>, Holder<Biome>>>> AND = ApoliBiomeConditions.of("and");
    public static final RegistryObject<DelegatedBiomeCondition<ConditionStreamConfiguration<ConfiguredBiomeCondition<?, ?>, Holder<Biome>>>> OR = ApoliBiomeConditions.of("or");
    public static final RegistryObject<CategoryBiomeCondition> CATEGORY = ApoliRegisters.BIOME_CONDITIONS.register("category", CategoryBiomeCondition::new);
    public static final RegistryObject<HighHumidityCondition> HIGH_HUMIDITY = ApoliRegisters.BIOME_CONDITIONS.register("high_humidity", HighHumidityCondition::new);
    public static final RegistryObject<PropertyBiomeCondition<Biome.Precipitation>> PRECIPITATION = ApoliRegisters.BIOME_CONDITIONS.register("precipitation", () -> new PropertyBiomeCondition<Biome.Precipitation>("precipitation", (Codec<Biome.Precipitation>)SerializableDataType.enumValue(Biome.Precipitation.class), (Function<Holder<Biome>, Biome.Precipitation>)((Function<Holder, Biome.Precipitation>)x -> x.m_203633_() ? ((Biome)x.m_203334_()).m_264600_(new BlockPos(0, 64, 0)) : null)));
    public static final RegistryObject<FloatComparingBiomeCondition> TEMPERATURE = ApoliRegisters.BIOME_CONDITIONS.register("temperature", () -> new FloatComparingBiomeCondition(x -> Float.valueOf(x.m_203633_() ? ((Biome)x.m_203334_()).m_47554_() : 0.2f)));
    public static final RegistryObject<InTagCondition> IN_TAG = ApoliRegisters.BIOME_CONDITIONS.register("in_tag", InTagCondition::new);

    private static <U extends BiomeCondition<?>> RegistryObject<U> of(String name) {
        return RegistryObject.create((ResourceLocation)Apoli.identifier(name), (ResourceLocation)ApoliRegistries.BIOME_CONDITION_KEY.m_135782_(), (String)"apoli");
    }

    public static ConfiguredBiomeCondition<?, ?> constant(boolean value) {
        return (ConfiguredBiomeCondition)((DelegatedBiomeCondition)CONSTANT.get()).configure(new ConstantConfiguration(value));
    }

    @SafeVarargs
    public static ConfiguredBiomeCondition<?, ?> and(HolderSet<ConfiguredBiomeCondition<?, ?>> ... conditions) {
        return (ConfiguredBiomeCondition)((DelegatedBiomeCondition)AND.get()).configure(ConditionStreamConfiguration.and(Arrays.asList(conditions), PREDICATE));
    }

    @SafeVarargs
    public static ConfiguredBiomeCondition<?, ?> or(HolderSet<ConfiguredBiomeCondition<?, ?>> ... conditions) {
        return (ConfiguredBiomeCondition)((DelegatedBiomeCondition)OR.get()).configure(ConditionStreamConfiguration.or(Arrays.asList(conditions), PREDICATE));
    }

    public static void bootstrap() {
        MetaFactories.defineMetaConditions(ApoliRegisters.BIOME_CONDITIONS, DelegatedBiomeCondition::new, ConfiguredBiomeCondition.CODEC_SET, PREDICATE);
    }
}

