/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.registry.action;

import io.github.apace100.apoli.Apoli;
import io.github.edwinmindcraft.apoli.api.MetaFactories;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.ItemAction;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.action.item.ConsumeItemAction;
import io.github.edwinmindcraft.apoli.common.action.item.DamageItemAction;
import io.github.edwinmindcraft.apoli.common.action.item.DelegatedItemAction;
import io.github.edwinmindcraft.apoli.common.action.item.HolderAction;
import io.github.edwinmindcraft.apoli.common.action.item.MergeNbtItemAction;
import io.github.edwinmindcraft.apoli.common.action.item.ModifyItemAction;
import io.github.edwinmindcraft.apoli.common.action.item.RemoveEnchantmentItemAction;
import io.github.edwinmindcraft.apoli.common.action.meta.ChanceConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.ChoiceConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.DelayAction;
import io.github.edwinmindcraft.apoli.common.action.meta.ExecuteMultipleConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.IfElseConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.IfElseListConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.NothingConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRegisters;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.tuple.Pair;

public class ApoliItemActions {
    public static final BiConsumer<ConfiguredItemAction<?, ?>, Pair<Level, Mutable<ItemStack>>> EXECUTOR = (action, pair) -> action.execute((Level)pair.getKey(), (Mutable<ItemStack>)((Mutable)pair.getValue()));
    public static final BiPredicate<ConfiguredItemCondition<?, ?>, Pair<Level, Mutable<ItemStack>>> PREDICATE = (condition, pair) -> condition.check((Level)pair.getKey(), (ItemStack)((Mutable)pair.getValue()).getValue());
    public static final Predicate<Pair<Level, Mutable<ItemStack>>> SERVERSIDE_PREDICATE = pair -> !((Level)pair.getLeft()).f_46443_;
    public static final RegistryObject<DelegatedItemAction<ExecuteMultipleConfiguration<ConfiguredItemAction<?, ?>, Pair<Level, Mutable<ItemStack>>>>> AND = ApoliItemActions.of("and");
    public static final RegistryObject<DelegatedItemAction<ChanceConfiguration<ConfiguredItemAction<?, ?>, Pair<Level, Mutable<ItemStack>>>>> CHANCE = ApoliItemActions.of("chance");
    public static final RegistryObject<DelegatedItemAction<IfElseConfiguration<ConfiguredItemCondition<?, ?>, ConfiguredItemAction<?, ?>, Pair<Level, Mutable<ItemStack>>>>> IF_ELSE = ApoliItemActions.of("if_else");
    public static final RegistryObject<DelegatedItemAction<IfElseListConfiguration<ConfiguredItemCondition<?, ?>, ConfiguredItemAction<?, ?>, Pair<Level, Mutable<ItemStack>>>>> IF_ELSE_LIST = ApoliItemActions.of("if_else_list");
    public static final RegistryObject<DelegatedItemAction<ChoiceConfiguration<ConfiguredItemAction<?, ?>, Pair<Level, Mutable<ItemStack>>>>> CHOICE = ApoliItemActions.of("choice");
    public static final RegistryObject<DelegatedItemAction<DelayAction<ConfiguredItemAction<?, ?>, Pair<Level, Mutable<ItemStack>>>>> DELAY = ApoliItemActions.of("delay");
    public static final RegistryObject<DelegatedItemAction<NothingConfiguration<Pair<Level, Mutable<ItemStack>>>>> NOTHING = ApoliItemActions.of("nothing");
    public static final RegistryObject<ConsumeItemAction> CONSUME = ApoliRegisters.ITEM_ACTIONS.register("consume", ConsumeItemAction::new);
    public static final RegistryObject<ModifyItemAction> MODIFY = ApoliRegisters.ITEM_ACTIONS.register("modify", ModifyItemAction::new);
    public static final RegistryObject<DamageItemAction> DAMAGE = ApoliRegisters.ITEM_ACTIONS.register("damage", DamageItemAction::new);
    public static final RegistryObject<MergeNbtItemAction> MERGE_NBT = ApoliRegisters.ITEM_ACTIONS.register("merge_nbt", MergeNbtItemAction::new);
    public static final RegistryObject<RemoveEnchantmentItemAction> REMOVE_ENCHANTMENT = ApoliRegisters.ITEM_ACTIONS.register("remove_enchantment", RemoveEnchantmentItemAction::new);
    public static final RegistryObject<HolderAction> HOLDER = ApoliRegisters.ITEM_ACTIONS.register("holder", HolderAction::new);

    private static <U extends ItemAction<?>> RegistryObject<U> of(String name) {
        return RegistryObject.create((ResourceLocation)Apoli.identifier(name), (ResourceLocation)ApoliRegistries.ITEM_ACTION_KEY.m_135782_(), (String)"apoli");
    }

    public static void bootstrap() {
        MetaFactories.defineMetaActions(ApoliRegisters.ITEM_ACTIONS, DelegatedItemAction::new, ConfiguredItemAction.CODEC_SET, ConfiguredItemCondition.CODEC_SET, ConfiguredItemAction::optional, EXECUTOR, PREDICATE, SERVERSIDE_PREDICATE);
    }
}

