/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.registry.action;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.action.entity.AreaOfEffectAction;
import io.github.apace100.apoli.action.entity.CraftingTableAction;
import io.github.apace100.apoli.action.entity.EnderChestAction;
import io.github.apace100.apoli.power.factory.action.entity.RaycastAction;
import io.github.apace100.apoli.power.factory.action.entity.SpawnParticlesAction;
import io.github.apace100.apoli.power.factory.action.entity.SwingHandAction;
import io.github.edwinmindcraft.apoli.api.MetaFactories;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityAction;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.action.configuration.ChangeResourceConfiguration;
import io.github.edwinmindcraft.apoli.common.action.entity.AddExperienceAction;
import io.github.edwinmindcraft.apoli.common.action.entity.AddVelocityAction;
import io.github.edwinmindcraft.apoli.common.action.entity.AdvancementAction;
import io.github.edwinmindcraft.apoli.common.action.entity.ApplyEffectAction;
import io.github.edwinmindcraft.apoli.common.action.entity.BlockActionAtAction;
import io.github.edwinmindcraft.apoli.common.action.entity.ChangeResourceAction;
import io.github.edwinmindcraft.apoli.common.action.entity.ClearEffectAction;
import io.github.edwinmindcraft.apoli.common.action.entity.DamageAction;
import io.github.edwinmindcraft.apoli.common.action.entity.DelegatedEntityAction;
import io.github.edwinmindcraft.apoli.common.action.entity.DropInventoryAction;
import io.github.edwinmindcraft.apoli.common.action.entity.EmitGameEventAction;
import io.github.edwinmindcraft.apoli.common.action.entity.EquippedItemAction;
import io.github.edwinmindcraft.apoli.common.action.entity.ExecuteCommandEntityAction;
import io.github.edwinmindcraft.apoli.common.action.entity.ExplodeAction;
import io.github.edwinmindcraft.apoli.common.action.entity.FeedAction;
import io.github.edwinmindcraft.apoli.common.action.entity.FireProjectileAction;
import io.github.edwinmindcraft.apoli.common.action.entity.FloatEntityAction;
import io.github.edwinmindcraft.apoli.common.action.entity.GiveAction;
import io.github.edwinmindcraft.apoli.common.action.entity.GrantPowerAction;
import io.github.edwinmindcraft.apoli.common.action.entity.IntegerEntityAction;
import io.github.edwinmindcraft.apoli.common.action.entity.ModifyDeathTicksAction;
import io.github.edwinmindcraft.apoli.common.action.entity.ModifyInventoryAction;
import io.github.edwinmindcraft.apoli.common.action.entity.ModifyResourceAction;
import io.github.edwinmindcraft.apoli.common.action.entity.ModifyStatAction;
import io.github.edwinmindcraft.apoli.common.action.entity.PassengerAction;
import io.github.edwinmindcraft.apoli.common.action.entity.PlaySoundAction;
import io.github.edwinmindcraft.apoli.common.action.entity.ReplaceInventoryAction;
import io.github.edwinmindcraft.apoli.common.action.entity.RevokePowerAction;
import io.github.edwinmindcraft.apoli.common.action.entity.RidingAction;
import io.github.edwinmindcraft.apoli.common.action.entity.SelectorAction;
import io.github.edwinmindcraft.apoli.common.action.entity.SimpleEntityAction;
import io.github.edwinmindcraft.apoli.common.action.entity.SpawnEffectCloudAction;
import io.github.edwinmindcraft.apoli.common.action.entity.SpawnEntityAction;
import io.github.edwinmindcraft.apoli.common.action.entity.ToggleAction;
import io.github.edwinmindcraft.apoli.common.action.entity.TriggerCooldownAction;
import io.github.edwinmindcraft.apoli.common.action.meta.ChanceConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.ChoiceConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.DelayAction;
import io.github.edwinmindcraft.apoli.common.action.meta.ExecuteMultipleConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.IfElseConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.IfElseListConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.NothingConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRegisters;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.RegistryObject;

public class ApoliEntityActions {
    public static final BiConsumer<ConfiguredEntityAction<?, ?>, Entity> EXECUTOR = ConfiguredEntityAction::execute;
    public static final BiPredicate<ConfiguredEntityCondition<?, ?>, Entity> PREDICATE = ConfiguredEntityCondition::check;
    public static final Predicate<Entity> SERVERSIDE_PREDICATE = entity -> !entity.m_9236_().f_46443_;
    public static final RegistryObject<DelegatedEntityAction<ExecuteMultipleConfiguration<ConfiguredEntityAction<?, ?>, Entity>>> AND = ApoliEntityActions.of("and");
    public static final RegistryObject<DelegatedEntityAction<ChanceConfiguration<ConfiguredEntityAction<?, ?>, Entity>>> CHANCE = ApoliEntityActions.of("chance");
    public static final RegistryObject<DelegatedEntityAction<IfElseConfiguration<ConfiguredEntityCondition<?, ?>, ConfiguredEntityAction<?, ?>, Entity>>> IF_ELSE = ApoliEntityActions.of("if_else");
    public static final RegistryObject<DelegatedEntityAction<IfElseListConfiguration<ConfiguredEntityCondition<?, ?>, ConfiguredEntityAction<?, ?>, Entity>>> IF_ELSE_LIST = ApoliEntityActions.of("if_else_list");
    public static final RegistryObject<DelegatedEntityAction<ChoiceConfiguration<ConfiguredEntityAction<?, ?>, Entity>>> CHOICE = ApoliEntityActions.of("choice");
    public static final RegistryObject<DelegatedEntityAction<DelayAction<ConfiguredEntityAction<?, ?>, Entity>>> DELAY = ApoliEntityActions.of("delay");
    public static final RegistryObject<DelegatedEntityAction<NothingConfiguration<Entity>>> NOTHING = ApoliEntityActions.of("nothing");
    public static final RegistryObject<AddVelocityAction> ADD_VELOCITY = ApoliRegisters.ENTITY_ACTIONS.register("add_velocity", AddVelocityAction::new);
    public static final RegistryObject<AddExperienceAction> ADD_EXPERIENCE = ApoliRegisters.ENTITY_ACTIONS.register("add_xp", AddExperienceAction::new);
    public static final RegistryObject<ApplyEffectAction> APPLY_EFFECT = ApoliRegisters.ENTITY_ACTIONS.register("apply_effect", ApplyEffectAction::new);
    public static final RegistryObject<BlockActionAtAction> BLOCK_ACTION_AT = ApoliRegisters.ENTITY_ACTIONS.register("block_action_at", BlockActionAtAction::new);
    public static final RegistryObject<ChangeResourceAction> CHANGE_RESOURCE = ApoliRegisters.ENTITY_ACTIONS.register("change_resource", () -> new ChangeResourceAction(ChangeResourceConfiguration.ANY_CODEC));
    public static final RegistryObject<ClearEffectAction> CLEAR_EFFECT = ApoliRegisters.ENTITY_ACTIONS.register("clear_effect", ClearEffectAction::new);
    public static final RegistryObject<SimpleEntityAction> EXTINGUISH = ApoliRegisters.ENTITY_ACTIONS.register("extinguish", () -> new SimpleEntityAction(Entity::m_20095_));
    public static final RegistryObject<ExecuteCommandEntityAction> EXECUTE_COMMAND = ApoliRegisters.ENTITY_ACTIONS.register("execute_command", ExecuteCommandEntityAction::new);
    public static final RegistryObject<IntegerEntityAction> SET_ON_FIRE = ApoliRegisters.ENTITY_ACTIONS.register("set_on_fire", () -> new IntegerEntityAction(Entity::m_20254_, "duration"));
    public static final RegistryObject<FloatEntityAction> EXHAUST = ApoliRegisters.ENTITY_ACTIONS.register("exhaust", () -> FloatEntityAction.ofPlayer((x, f) -> x.m_36324_().m_38703_(f.floatValue()), "amount"));
    public static final RegistryObject<FloatEntityAction> HEAL = ApoliRegisters.ENTITY_ACTIONS.register("heal", () -> FloatEntityAction.ofLiving(LivingEntity::m_5634_, "amount"));
    public static final RegistryObject<IntegerEntityAction> GAIN_AIR = ApoliRegisters.ENTITY_ACTIONS.register("gain_air", () -> IntegerEntityAction.ofLiving((x, f) -> x.m_20301_(Math.min(x.m_20146_() + f, x.m_6062_())), "value"));
    public static final RegistryObject<FloatEntityAction> SET_FALL_DISTANCE = ApoliRegisters.ENTITY_ACTIONS.register("set_fall_distance", () -> new FloatEntityAction((entity, f) -> {
        entity.f_19789_ = f.floatValue();
    }, "fall_distance"));
    public static final RegistryObject<DamageAction> DAMAGE = ApoliRegisters.ENTITY_ACTIONS.register("damage", DamageAction::new);
    public static final RegistryObject<EquippedItemAction> EQUIPPED_ITEM_ACTION = ApoliRegisters.ENTITY_ACTIONS.register("equipped_item_action", EquippedItemAction::new);
    public static final RegistryObject<FeedAction> FEED = ApoliRegisters.ENTITY_ACTIONS.register("feed", FeedAction::new);
    public static final RegistryObject<GiveAction> GIVE = ApoliRegisters.ENTITY_ACTIONS.register("give", GiveAction::new);
    public static final RegistryObject<PlaySoundAction> PLAY_SOUND = ApoliRegisters.ENTITY_ACTIONS.register("play_sound", PlaySoundAction::new);
    public static final RegistryObject<SpawnEffectCloudAction> SPAWN_EFFECT_CLOUD = ApoliRegisters.ENTITY_ACTIONS.register("spawn_effect_cloud", SpawnEffectCloudAction::new);
    public static final RegistryObject<SpawnEntityAction> SPAWN_ENTITY = ApoliRegisters.ENTITY_ACTIONS.register("spawn_entity", SpawnEntityAction::new);
    public static final RegistryObject<TriggerCooldownAction> TRIGGER_COOLDOWN = ApoliRegisters.ENTITY_ACTIONS.register("trigger_cooldown", TriggerCooldownAction::new);
    public static final RegistryObject<ToggleAction> TOGGLE = ApoliRegisters.ENTITY_ACTIONS.register("toggle", ToggleAction::new);
    public static final RegistryObject<EmitGameEventAction> EMIT_GAME_EVENT = ApoliRegisters.ENTITY_ACTIONS.register("emit_game_event", EmitGameEventAction::new);
    public static final RegistryObject<ChangeResourceAction> SET_RESOURCE = ApoliRegisters.ENTITY_ACTIONS.register("set_resource", () -> new ChangeResourceAction(ChangeResourceConfiguration.SET_CODEC));
    public static final RegistryObject<GrantPowerAction> GRANT_POWER = ApoliRegisters.ENTITY_ACTIONS.register("grant_power", GrantPowerAction::new);
    public static final RegistryObject<RevokePowerAction> REVOKE_POWER = ApoliRegisters.ENTITY_ACTIONS.register("revoke_power", RevokePowerAction::new);
    public static final RegistryObject<ExplodeAction> EXPLODE = ApoliRegisters.ENTITY_ACTIONS.register("explode", ExplodeAction::new);
    public static final RegistryObject<SimpleEntityAction> DISMOUNT = ApoliRegisters.ENTITY_ACTIONS.register("dismount", () -> new SimpleEntityAction(Entity::m_8127_));
    public static final RegistryObject<PassengerAction> PASSENGER_ACTION = ApoliRegisters.ENTITY_ACTIONS.register("passenger_action", PassengerAction::new);
    public static final RegistryObject<RidingAction> RIDING_ACTION = ApoliRegisters.ENTITY_ACTIONS.register("riding_action", RidingAction::new);
    public static final RegistryObject<AreaOfEffectAction> AREA_OF_EFFECT = ApoliRegisters.ENTITY_ACTIONS.register("area_of_effect", AreaOfEffectAction::new);
    public static final RegistryObject<CraftingTableAction> CRAFTING_TABLE = ApoliRegisters.ENTITY_ACTIONS.register("crafting_table", CraftingTableAction::new);
    public static final RegistryObject<EnderChestAction> ENDER_CHEST = ApoliRegisters.ENTITY_ACTIONS.register("ender_chest", EnderChestAction::new);
    public static final RegistryObject<SwingHandAction> SWING_HAND = ApoliRegisters.ENTITY_ACTIONS.register("swing_hand", SwingHandAction::new);
    public static final RegistryObject<RaycastAction> RAYCAST = ApoliRegisters.ENTITY_ACTIONS.register("raycast", RaycastAction::new);
    public static final RegistryObject<SpawnParticlesAction> SPAWN_PARTICLES = ApoliRegisters.ENTITY_ACTIONS.register("spawn_particles", SpawnParticlesAction::new);
    public static final RegistryObject<ModifyDeathTicksAction> MODIFY_DEATH_TICKS = ApoliRegisters.ENTITY_ACTIONS.register("modify_death_ticks", ModifyDeathTicksAction::new);
    public static final RegistryObject<ModifyResourceAction> MODIFY_RESOURCE = ApoliRegisters.ENTITY_ACTIONS.register("modify_resource", ModifyResourceAction::new);
    public static final RegistryObject<DropInventoryAction> DROP_INVENTORY = ApoliRegisters.ENTITY_ACTIONS.register("drop_inventory", DropInventoryAction::new);
    public static final RegistryObject<ModifyInventoryAction> MODIFY_INVENTORY = ApoliRegisters.ENTITY_ACTIONS.register("modify_inventory", ModifyInventoryAction::new);
    public static final RegistryObject<ReplaceInventoryAction> REPLACE_INVENTORY = ApoliRegisters.ENTITY_ACTIONS.register("replace_inventory", ReplaceInventoryAction::new);
    public static final RegistryObject<ModifyStatAction> MODIFY_STAT = ApoliRegisters.ENTITY_ACTIONS.register("modify_stat", ModifyStatAction::new);
    public static final RegistryObject<AdvancementAction> GRANT_ADVANCEMENT = ApoliRegisters.ENTITY_ACTIONS.register("grant_advancement", AdvancementAction::grant);
    public static final RegistryObject<AdvancementAction> REVOKE_ADVANCEMENT = ApoliRegisters.ENTITY_ACTIONS.register("revoke_advancement", AdvancementAction::revoke);
    public static final RegistryObject<SelectorAction> SELECTOR = ApoliRegisters.ENTITY_ACTIONS.register("selector", SelectorAction::new);
    public static final RegistryObject<FireProjectileAction> FIRE_PROJECTILE = ApoliRegisters.ENTITY_ACTIONS.register("fire_projectile", FireProjectileAction::new);

    private static <U extends EntityAction<?>> RegistryObject<U> of(String name) {
        return RegistryObject.create((ResourceLocation)Apoli.identifier(name), (ResourceLocation)ApoliRegistries.ENTITY_ACTION_KEY.m_135782_(), (String)"apoli");
    }

    @SafeVarargs
    public static ConfiguredEntityAction<?, ?> and(HolderSet<ConfiguredEntityAction<?, ?>> ... conditions) {
        return ((DelegatedEntityAction)AND.get()).configure(new ExecuteMultipleConfiguration(Arrays.asList(conditions), EXECUTOR));
    }

    public static ConfiguredEntityAction<?, ?> and(ConfiguredEntityAction<?, ?> ... conditions) {
        return ApoliEntityActions.and(new HolderSet[]{HolderSet.m_205806_(Holder::m_205709_, (Object[])conditions)});
    }

    public static void bootstrap() {
        MetaFactories.defineMetaActions(ApoliRegisters.ENTITY_ACTIONS, DelegatedEntityAction::new, ConfiguredEntityAction.CODEC_SET, ConfiguredEntityCondition.CODEC_SET, ConfiguredEntityAction::optional, EXECUTOR, PREDICATE, SERVERSIDE_PREDICATE);
    }
}

