/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.ClassUtil;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.NonNullSupplier;

public record ReplaceLootTableConfiguration(Map<String, ResourceLocation> replacements, int priority, Holder<ConfiguredItemCondition<?, ?>> itemCondition, Holder<ConfiguredBiEntityCondition<?, ?>> biEntityCondition, Holder<ConfiguredBlockCondition<?, ?>> blockCondition) implements IDynamicFeatureConfiguration
{
    private static final SerializableDataType<Map<String, ResourceLocation>> REPLACEMENTS_DATA_TYPE = new SerializableDataType(ClassUtil.castClass(Map.class), (packetByteBuf, stringIdentifierMap) -> {
        packetByteBuf.writeInt(stringIdentifierMap.size());
        stringIdentifierMap.forEach((s, identifier) -> {
            packetByteBuf.m_130070_(s);
            packetByteBuf.m_130085_(identifier);
        });
    }, packetByteBuf -> {
        int count = packetByteBuf.readInt();
        LinkedHashMap<String, ResourceLocation> map = new LinkedHashMap<String, ResourceLocation>();
        for (int i = 0; i < count; ++i) {
            String s = packetByteBuf.m_130277_();
            ResourceLocation id = packetByteBuf.m_130281_();
            map.put(s, id);
        }
        return map;
    }, jsonElement -> {
        if (jsonElement.isJsonObject()) {
            JsonObject jo = jsonElement.getAsJsonObject();
            LinkedHashMap<String, ResourceLocation> map = new LinkedHashMap<String, ResourceLocation>();
            for (String s : jo.keySet()) {
                JsonPrimitive jp;
                JsonElement ele = jo.get(s);
                if (!ele.isJsonPrimitive() || !(jp = ele.getAsJsonPrimitive()).isString()) continue;
                ResourceLocation id = new ResourceLocation(jp.getAsString());
                map.put(s, id);
            }
            return map;
        }
        throw new JsonParseException("Expected a JSON object");
    });
    public static final Codec<ReplaceLootTableConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)REPLACEMENTS_DATA_TYPE.fieldOf("replace").forGetter(ReplaceLootTableConfiguration::replacements), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.INT, (String)"priority", (Object)0).forGetter(ReplaceLootTableConfiguration::priority), (App)ConfiguredItemCondition.optional("item_condition").forGetter(ReplaceLootTableConfiguration::itemCondition), (App)ConfiguredBiEntityCondition.optional("bientity_condition").forGetter(ReplaceLootTableConfiguration::biEntityCondition), (App)ConfiguredBlockCondition.optional("block_condition").forGetter(ReplaceLootTableConfiguration::blockCondition)).apply((Applicative)instance, ReplaceLootTableConfiguration::new));

    public boolean hasReplacement(ResourceLocation id) {
        String idString = id.toString();
        if (this.replacements().containsKey(idString)) {
            return true;
        }
        return this.replacements().keySet().stream().anyMatch(idString::matches);
    }

    public boolean doesApply(LootContext lootContext, Entity entity) {
        if (!ConfiguredBiEntityCondition.check(this.biEntityCondition(), entity, (Entity)lootContext.m_165124_(LootContextParams.f_81455_))) {
            return false;
        }
        if (lootContext.m_78936_(LootContextParams.f_81463_) && !ConfiguredItemCondition.check(this.itemCondition(), (Level)lootContext.m_78952_(), (ItemStack)lootContext.m_165124_(LootContextParams.f_81463_))) {
            return false;
        }
        if (lootContext.m_78936_(LootContextParams.f_81460_)) {
            Vec3 origin = (Vec3)lootContext.m_165124_(LootContextParams.f_81460_);
            BlockPos blockPos = BlockPos.m_274446_((Position)origin);
            return ConfiguredBlockCondition.check(this.blockCondition(), (LevelReader)lootContext.m_78952_(), blockPos, (NonNullSupplier<BlockState>)((NonNullSupplier)() -> (BlockState)lootContext.m_165124_(LootContextParams.f_81461_)));
        }
        return true;
    }

    @Nullable
    public ResourceLocation getReplacement(ResourceLocation id) {
        String idString = id.toString();
        if (this.replacements.containsKey(idString)) {
            return this.replacements.get(idString);
        }
        Set<String> keys = this.replacements.keySet();
        for (String s : keys) {
            if (!idString.matches(s)) continue;
            return this.replacements.get(s);
        }
        return null;
    }
}

