/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public record ModifyPlayerSpawnConfiguration(ResourceKey<Level> dimension, float distanceMultiplier, @Nullable ResourceKey<Biome> biome, SpawnStrategy strategy, @Nullable ResourceKey<Structure> structure, @Nullable SoundEvent sound) implements IDynamicFeatureConfiguration
{
    public static final Codec<ModifyPlayerSpawnConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableDataTypes.DIMENSION.fieldOf("dimension").forGetter(ModifyPlayerSpawnConfiguration::dimension), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.FLOAT, (String)"dimension_distance_multiplier", (Object)Float.valueOf(0.0f)).forGetter(ModifyPlayerSpawnConfiguration::distanceMultiplier), (App)CalioCodecHelper.resourceKey((ResourceKey)Registries.f_256952_).optionalFieldOf("biome").forGetter(x -> Optional.ofNullable(x.biome())), (App)CalioCodecHelper.optionalField((Codec)SerializableDataType.enumValue(SpawnStrategy.class), (String)"spawn_strategy", (Object)((Object)SpawnStrategy.DEFAULT)).forGetter(ModifyPlayerSpawnConfiguration::strategy), (App)CalioCodecHelper.optionalField((Codec)SerializableDataType.registryKey((ResourceKey)Registries.f_256944_), (String)"structure").forGetter(x -> Optional.ofNullable(x.structure())), (App)CalioCodecHelper.optionalField((Codec)SerializableDataTypes.SOUND_EVENT, (String)"respawn_sound").forGetter(x -> Optional.ofNullable(x.sound()))).apply((Applicative)instance, (t1, t2, t3, t4, t5, t6) -> new ModifyPlayerSpawnConfiguration((ResourceKey<Level>)t1, t2.floatValue(), (ResourceKey<Biome>)((ResourceKey)t3.orElse(null)), (SpawnStrategy)((Object)((Object)t4)), (ResourceKey<Structure>)((ResourceKey)t5.orElse(null)), t6.orElse(null))));

    public Optional<BlockPos> getBiomePos(ResourceLocation powerId, ServerLevel targetDimension, BlockPos originPos) {
        if (this.biome() == null) {
            return Optional.empty();
        }
        Optional targetBiome = targetDimension.m_9598_().m_175515_(Registries.f_256952_).m_123009_(this.biome());
        if (targetBiome.isEmpty()) {
            Apoli.LOGGER.warn("Power {} could not set spawnpoint at biome \"{}\" as it's not registered in dimension \"{}\".", (Object)powerId, (Object)this.biome().m_135782_(), (Object)this.dimension().m_135782_());
            return Optional.empty();
        }
        Pair targetBiomePos = targetDimension.m_215069_(biome -> biome.m_203334_() == targetBiome.get(), originPos, 6400, 8, 8);
        if (targetBiomePos != null) {
            return Optional.of((BlockPos)targetBiomePos.getFirst());
        }
        Apoli.LOGGER.warn("Power {} could not set spawnpoint at biome \"{}\" as it couldn't be found in dimension \"{}\".", (Object)powerId, (Object)this.biome().m_135782_(), (Object)this.dimension().m_135782_());
        return Optional.empty();
    }

    private Optional<Pair<BlockPos, Structure>> getStructurePos(ResourceLocation powerId, Level world, @Nullable ResourceKey<Structure> structure, @Nullable TagKey<Structure> structureTag, ResourceKey<Level> dimension) {
        MinecraftServer server;
        Registry structureRegistry = world.m_9598_().m_175515_(Registries.f_256944_);
        HolderSet structureRegistryEntryList = null;
        Object structureTagOrName = "";
        if (structure != null) {
            Optional entry = structureRegistry.m_203636_(structure);
            if (entry.isPresent()) {
                structureRegistryEntryList = HolderSet.m_205809_((Holder[])new Holder[]{(Holder)entry.get()});
            }
            structureTagOrName = structure.m_135782_().toString();
        }
        if (structureRegistryEntryList == null) {
            Optional entryList = structureRegistry.m_203431_(structureTag);
            if (entryList.isPresent()) {
                structureRegistryEntryList = (HolderSet)entryList.get();
            }
            structureTagOrName = "#" + structureTag.f_203868_().toString();
        }
        if ((server = world.m_7654_()) == null) {
            return Optional.empty();
        }
        ServerLevel serverWorld = server.m_129880_(dimension);
        if (serverWorld == null) {
            return Optional.empty();
        }
        BlockPos center = new BlockPos(0, 70, 0);
        Pair structurePos = serverWorld.m_7726_().m_8481_().m_223037_(serverWorld, structureRegistryEntryList, center, 100, false);
        if (structurePos == null) {
            Apoli.LOGGER.warn("Power {} could not set spawnpoint at structure \"{}\" as it couldn't be found in dimension \"{}\".", (Object)powerId, structureTagOrName, (Object)dimension.m_135782_());
            return Optional.empty();
        }
        return Optional.of(new Pair((Object)((BlockPos)structurePos.getFirst()), (Object)((Structure)((Holder)structurePos.getSecond()).m_203334_())));
    }

    public Optional<Vec3> getSpawnPos(ResourceLocation powerId, ServerLevel targetDimension, BlockPos originPos, int range) {
        if (this.structure() == null) {
            return ModifyPlayerSpawnConfiguration.getValidSpawn(originPos, range, targetDimension);
        }
        Optional<Pair<BlockPos, Structure>> targetStructure = this.getStructurePos(powerId, (Level)targetDimension, this.structure(), null, this.dimension());
        if (targetStructure.isEmpty()) {
            return Optional.empty();
        }
        BlockPos targetStructurePos = (BlockPos)targetStructure.get().getFirst();
        ChunkPos targetStructureChunkPos = new ChunkPos(targetStructurePos.m_123341_() >> 4, targetStructurePos.m_123343_() >> 4);
        StructureStart targetStructureStart = targetDimension.m_215010_().m_220512_(SectionPos.m_123196_((ChunkPos)targetStructureChunkPos, (int)0), (Structure)targetStructure.get().getSecond(), (StructureAccess)targetDimension.m_46865_(targetStructurePos));
        if (targetStructureStart == null) {
            return Optional.empty();
        }
        BlockPos targetStructureCenter = new BlockPos((Vec3i)targetStructureStart.m_73601_().m_162394_());
        return ModifyPlayerSpawnConfiguration.getValidSpawn(targetStructureCenter, range, targetDimension);
    }

    private static Optional<Vec3> getValidSpawn(BlockPos startPos, int range, ServerLevel world) {
        world.m_6522_(startPos.m_123341_() >> 4, startPos.m_123343_() >> 4, ChunkStatus.f_62326_, true);
        int dx = 1;
        int dz = 0;
        int segmentLength = 1;
        BlockPos.MutableBlockPos mutable = startPos.m_122032_();
        int center = startPos.m_123342_();
        int x = startPos.m_123341_();
        int z = startPos.m_123343_();
        int segmentPassed = 0;
        int i = 0;
        for (int d = 0; i < world.m_143344_() || d > 0; ++i, --d) {
            for (int coordinateCount = 0; coordinateCount < range; ++coordinateCount) {
                ++segmentPassed;
                mutable.m_122178_(x += dx, center + i, z += dz);
                Vec3 tpPos = DismountHelper.m_38441_((EntityType)EntityType.f_20532_, (CollisionGetter)world, (BlockPos)mutable, (boolean)true);
                if (tpPos != null) {
                    return Optional.of(tpPos);
                }
                mutable.m_142448_(center + d);
                tpPos = DismountHelper.m_38441_((EntityType)EntityType.f_20532_, (CollisionGetter)world, (BlockPos)mutable, (boolean)true);
                if (tpPos != null) {
                    return Optional.of(tpPos);
                }
                if (segmentPassed != segmentLength) continue;
                segmentPassed = 0;
                int buffer = dx;
                dx = -dz;
                dz = buffer;
                if (dz != 0) continue;
                ++segmentLength;
            }
        }
        return Optional.empty();
    }

    @Nullable
    public Tuple<ServerLevel, BlockPos> getSpawn(ResourceLocation powerId, Entity entity, boolean isSpawnObstructed) {
        if (entity instanceof ServerPlayer) {
            // empty if block
        }
        return null;
    }

    public static enum SpawnStrategy {
        CENTER((TriFunction<BlockPos, Integer, Float, BlockPos>)((TriFunction)(blockPos, center, multiplier) -> new BlockPos(0, center.intValue(), 0))),
        DEFAULT((TriFunction<BlockPos, Integer, Float, BlockPos>)((TriFunction)(blockPos, center, multiplier) -> {
            BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
            if (multiplier.floatValue() != 0.0f) {
                mut.m_122169_((double)((float)blockPos.m_123341_() * multiplier.floatValue()), (double)blockPos.m_123342_(), (double)((float)blockPos.m_123343_() * multiplier.floatValue()));
            } else {
                mut.m_122190_((Vec3i)blockPos);
            }
            return mut;
        }));

        final TriFunction<BlockPos, Integer, Float, BlockPos> strategyApplier;

        private SpawnStrategy(TriFunction<BlockPos, Integer, Float, BlockPos> strategyApplier) {
            this.strategyApplier = strategyApplier;
        }

        public BlockPos apply(BlockPos blockPos, int center, float multiplier) {
            return (BlockPos)this.strategyApplier.apply((Object)blockPos, (Object)center, (Object)Float.valueOf(multiplier));
        }
    }
}

