/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.edwinmindcraft.apoli.api.configuration.ListConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredModifier;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyAttributeConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliModifierOperations;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.ForgeMod;

public final class ModifyFallingConfiguration
extends ModifyAttributeConfiguration {
    public static final Codec<ModifyFallingConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.DOUBLE, (String)"velocity").forGetter(ModifyFallingConfiguration::velocity), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"take_fall_damage", (Object)true).forGetter(ModifyFallingConfiguration::takeFallDamage), (App)ListConfiguration.MODIFIER_CODEC.forGetter(ModifyAttributeConfiguration::modifiers)).apply((Applicative)instance, ModifyFallingConfiguration::new));
    private final Optional<Double> velocity;
    private final boolean takeFallDamage;

    public ModifyFallingConfiguration(Optional<Double> velocity, boolean takeFallDamage, ListConfiguration<ConfiguredModifier<?>> modifiers) {
        super((Attribute)ForgeMod.ENTITY_GRAVITY.get(), velocity.map(aDouble -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(modifiers.getContent());
            builder.add(ModifierUtil.createSimpleModifier(() -> ApoliModifierOperations.SET_TOTAL.get(), aDouble));
            return new ListConfiguration(builder.build());
        }).orElse(modifiers));
        this.velocity = velocity;
        this.takeFallDamage = takeFallDamage;
    }

    public Optional<Double> velocity() {
        return this.velocity;
    }

    public boolean takeFallDamage() {
        return this.takeFallDamage;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ModifyFallingConfiguration that = (ModifyFallingConfiguration)obj;
        return this.velocity().isPresent() == that.velocity().isPresent() && (this.velocity().isEmpty() || Double.doubleToLongBits(this.velocity.get()) == Double.doubleToLongBits(that.velocity.get())) && this.takeFallDamage == that.takeFallDamage && this.modifiers().entries() == that.modifiers().entries();
    }

    public int hashCode() {
        return Objects.hash(this.velocity, this.takeFallDamage, this.modifiers());
    }

    public String toString() {
        return "ModifyFallingConfiguration[velocity=" + this.velocity + ", takeFallDamage=" + this.takeFallDamage + ", modifiers=" + this.modifiers() + "]";
    }
}

