/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public record ColorConfiguration(float red, float green, float blue, float alpha) implements IDynamicFeatureConfiguration
{
    public static ColorConfiguration DEFAULT = new ColorConfiguration(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Codec<ColorConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.FLOAT, (String)"red", (Object)Float.valueOf(1.0f)).forGetter(ColorConfiguration::red), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.FLOAT, (String)"green", (Object)Float.valueOf(1.0f)).forGetter(ColorConfiguration::green), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.FLOAT, (String)"blue", (Object)Float.valueOf(1.0f)).forGetter(ColorConfiguration::blue), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.FLOAT, (String)"alpha", (Object)Float.valueOf(1.0f)).forGetter(ColorConfiguration::alpha)).apply((Applicative)instance, ColorConfiguration::new));
    public static final MapCodec<ColorConfiguration> NO_ALPHA = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.FLOAT, (String)"red", (Object)Float.valueOf(1.0f)).forGetter(ColorConfiguration::red), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.FLOAT, (String)"green", (Object)Float.valueOf(1.0f)).forGetter(ColorConfiguration::green), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.FLOAT, (String)"blue", (Object)Float.valueOf(1.0f)).forGetter(ColorConfiguration::blue)).apply((Applicative)instance, ColorConfiguration::new));

    public ColorConfiguration(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public static Optional<ColorConfiguration> forPower(Entity entity, PowerFactory<ColorConfiguration> factory) {
        return IPowerContainer.getPowers(entity, factory).stream().map(Holder::m_203334_).map(ConfiguredPower::getConfiguration).reduce(ColorConfiguration::merge);
    }

    public ColorConfiguration merge(ColorConfiguration other) {
        return new ColorConfiguration(this.red() * other.red(), this.green() * other.green(), this.blue() * other.blue(), Math.min(this.alpha(), other.alpha()));
    }

    public ColorConfiguration multiply(float value) {
        return new ColorConfiguration(this.red() * value, this.green() * value, this.blue() * value, this.alpha() * value);
    }

    public ColorConfiguration withAlpha(float alpha) {
        return new ColorConfiguration(this.red(), this.green(), this.blue(), alpha);
    }

    public int asRGB() {
        int blue = Mth.m_14045_((int)((int)(this.blue() * 255.0f)), (int)0, (int)255);
        int green = Mth.m_14045_((int)((int)(this.green() * 255.0f)), (int)0, (int)255);
        int red = Mth.m_14045_((int)((int)(this.red() * 255.0f)), (int)0, (int)255);
        return (red << 8 | green) << 8 | blue;
    }
}

