/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.apace100.apoli.Apoli;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.StartingInventoryConfiguration;
import java.util.Comparator;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class StartingEquipmentPower
extends PowerFactory<StartingInventoryConfiguration> {
    public StartingEquipmentPower() {
        super(StartingInventoryConfiguration.CODEC, false);
    }

    @Override
    protected void onGained(StartingInventoryConfiguration configuration, Entity player) {
        if (player instanceof Player) {
            Player ple = (Player)player;
            this.giveStacks(configuration, ple);
        }
    }

    @Override
    protected void onRespawn(StartingInventoryConfiguration configuration, Entity player) {
        if (configuration.recurrent() && player instanceof Player) {
            Player ple = (Player)player;
            this.giveStacks(configuration, ple);
        }
    }

    private void giveStacks(StartingInventoryConfiguration configuration, Player player) {
        configuration.stacks().getContent().stream().sorted(Comparator.comparingInt(Tuple::m_14418_).reversed()).forEach(x -> {
            Apoli.LOGGER.info("Giving player {} stack: {}", (Object)player.m_7755_().getString(), (Object)((ItemStack)x.m_14419_()).toString());
            int pos = (Integer)x.m_14418_();
            if (pos > 0 && player.m_150109_().m_8020_(pos).m_41619_()) {
                player.m_150109_().m_6836_(pos, ((ItemStack)x.m_14419_()).m_41777_());
            } else {
                player.m_36356_(((ItemStack)x.m_14419_()).m_41777_());
            }
        });
    }
}

