/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.StackingStatusEffectConfiguration;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class StackingStatusEffectPower
extends PowerFactory<StackingStatusEffectConfiguration> {
    public StackingStatusEffectPower() {
        super(StackingStatusEffectConfiguration.CODEC);
        this.ticking(true);
    }

    public AtomicInteger getCurrentStacks(ConfiguredPower<StackingStatusEffectConfiguration, ?> configuration, Entity player) {
        return (AtomicInteger)configuration.getPowerData(player, () -> new AtomicInteger(0));
    }

    public AtomicInteger getCurrentStacks(ConfiguredPower<StackingStatusEffectConfiguration, ?> configuration, IPowerContainer player) {
        return (AtomicInteger)configuration.getPowerData(player, () -> new AtomicInteger(0));
    }

    @Override
    public void tick(ConfiguredPower<StackingStatusEffectConfiguration, ?> configuration, Entity player) {
        AtomicInteger currentStacks = this.getCurrentStacks(configuration, player);
        StackingStatusEffectConfiguration config = configuration.getConfiguration();
        if (configuration.isActive(player)) {
            int i = currentStacks.addAndGet(1);
            if (i > config.max()) {
                currentStacks.set(config.max());
            }
            if (i > 0) {
                this.applyEffects(configuration, player);
            }
        } else {
            int i = currentStacks.addAndGet(-1);
            if (i < config.min()) {
                currentStacks.set(config.min());
            }
        }
    }

    @Override
    protected int tickInterval(StackingStatusEffectConfiguration configuration, Entity player) {
        return configuration.tickRate();
    }

    @Override
    public void serialize(ConfiguredPower<StackingStatusEffectConfiguration, ?> configuration, IPowerContainer container, CompoundTag tag) {
        tag.m_128405_("CurrentStacks", this.getCurrentStacks(configuration, container).get());
    }

    @Override
    public void deserialize(ConfiguredPower<StackingStatusEffectConfiguration, ?> configuration, IPowerContainer container, CompoundTag tag) {
        this.getCurrentStacks(configuration, container).set(tag.m_128451_("CurrentStacks"));
    }

    public void applyEffects(ConfiguredPower<StackingStatusEffectConfiguration, ?> configuration, Entity entity) {
        LivingEntity living;
        block3: {
            block2: {
                if (!(entity instanceof LivingEntity)) break block2;
                living = (LivingEntity)entity;
                if (!entity.m_9236_().m_5776_()) break block3;
            }
            return;
        }
        configuration.getConfiguration().effects().getContent().forEach(sei -> {
            int duration = ((StackingStatusEffectConfiguration)configuration.getConfiguration()).duration() * this.getCurrentStacks(configuration, (Entity)living).get();
            if (duration > 0) {
                MobEffectInstance applySei = new MobEffectInstance(sei.m_19544_(), duration, sei.m_19564_(), sei.m_19571_(), sei.m_19572_(), sei.m_19575_());
                living.m_7292_(applySei);
            }
        });
    }
}

