/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import io.github.apace100.apoli.integration.PowerLoadEvent;
import io.github.apace100.calio.data.SerializableData;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.apoli.common.power.configuration.MultipleConfiguration;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class MultiplePower
extends PowerFactory<MultipleConfiguration<ConfiguredPower<?, ?>>> {
    private static final ImmutableSet<String> EXCLUDED = ImmutableSet.of((Object)"type", (Object)"loading_priority", (Object)"name", (Object)"description", (Object)"hidden", (Object)"condition", (Object[])new String[]{"conditions", "fabric:load_conditions", "forge:conditions"});
    private static final Predicate<String> ALLOWED = str -> !EXCLUDED.contains(str) && !ApoliAPI.isAdditionalDataField(str) && !str.startsWith("$");

    public MultiplePower() {
        super(MultipleConfiguration.mapCodec(ConfiguredPower.CODEC, ConfiguredPower.HOLDER, ALLOWED, s -> "_" + s, MultiplePower::reconfigure).codec(), false);
    }

    @Override
    public Map<String, Holder<ConfiguredPower<?, ?>>> getContainedPowers(ConfiguredPower<MultipleConfiguration<ConfiguredPower<?, ?>>, ?> configuration) {
        return configuration.getConfiguration().children();
    }

    private static <C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>> ConfiguredPower<C, ?> reconfigure(String suffix, ConfiguredPower<C, F> source, JsonElement root) {
        ResourceLocation name = new ResourceLocation(SerializableData.CURRENT_NAMESPACE, SerializableData.CURRENT_PATH + "_" + suffix);
        MinecraftForge.EVENT_BUS.post((Event)new PowerLoadEvent.Post(name, root, source));
        return ((PowerFactory)source.getFactory()).configure(source.getConfiguration(), source.getData().copyOf().hidden().build());
    }

    @Override
    public MultipleConfiguration<ConfiguredPower<?, ?>> complete(ResourceLocation identifier, MultipleConfiguration<ConfiguredPower<?, ?>> configuration) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        MappedRegistry<ConfiguredPower<?, ?>> powers = ApoliAPI.getPowers();
        for (String entry : configuration.children().keySet()) {
            ResourceLocation powerName = new ResourceLocation(identifier.m_135827_(), identifier.m_135815_() + entry);
            Holder.Reference holder = powers.m_203505_().m_255043_(ResourceKey.m_135785_(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, (ResourceLocation)powerName));
            builder.put((Object)entry, (Object)holder);
        }
        return new MultipleConfiguration((Map<String, Holder<ConfiguredPower<?, ?>>>)builder.build());
    }
}

