/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import com.google.common.collect.Sets;
import io.github.apace100.apoli.util.ApoliConfigs;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.ApoliCommon;
import io.github.edwinmindcraft.apoli.common.network.S2CActiveSpawnPowerPacket;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyPlayerSpawnConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.apoli.common.util.ModifyPlayerSpawnCache;
import io.github.edwinmindcraft.apoli.common.util.SpawnLookupScheduler;
import io.github.edwinmindcraft.apoli.common.util.SpawnLookupUtil;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Tuple;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ModifyPlayerSpawnPower
extends PowerFactory<ModifyPlayerSpawnConfiguration> {
    private static final Set<ServerPlayer> PLAYERS_TO_RESPAWN = Sets.newHashSet();

    public ModifyPlayerSpawnPower() {
        super(ModifyPlayerSpawnConfiguration.CODEC);
    }

    public void teleportToModifiedSpawn(ConfiguredPower<?, ?> configuration, Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Tuple<ResourceKey<ConfiguredPower<?, ?>>, Tuple<ServerLevel, Vec3>> cachedSpawn = this.getSpawn(configuration, entity, false);
            if (cachedSpawn != null) {
                Tuple spawn = (Tuple)cachedSpawn.m_14419_();
                BlockPos spawnLocation = new BlockPos((int)((Vec3)spawn.m_14419_()).f_82479_, (int)((Vec3)spawn.m_14419_()).f_82480_, (int)((Vec3)spawn.m_14419_()).f_82481_);
                ((ServerLevel)spawn.m_14418_()).m_7726_().m_8387_(TicketType.f_9442_, new ChunkPos(spawnLocation), 11, (Object)Unit.INSTANCE);
                serverPlayer.m_8999_((ServerLevel)spawn.m_14418_(), ((Vec3)spawn.m_14419_()).f_82479_, ((Vec3)spawn.m_14419_()).f_82480_, ((Vec3)spawn.m_14419_()).f_82481_, entity.m_146909_(), entity.m_146908_());
            }
        }
    }

    public void checkSpawn(ServerPlayer entity) {
        @Nullable ResourceKey<ConfiguredPower<?, ?>> activeKey = ((ModifyPlayerSpawnCache)entity).getActiveSpawnPower();
        if (activeKey != null && SpawnLookupUtil.hasSpawnCached(activeKey)) {
            Tuple<ServerLevel, Vec3> spawn = SpawnLookupUtil.getSpawnCache(activeKey);
            if (spawn == null) {
                return;
            }
            Vec3 tpPos = DismountHelper.m_38441_((EntityType)EntityType.f_20532_, (CollisionGetter)((CollisionGetter)spawn.m_14418_()), (BlockPos)new BlockPos((int)((Vec3)spawn.m_14419_()).f_82479_, (int)((Vec3)spawn.m_14419_()).f_82480_, (int)((Vec3)spawn.m_14419_()).f_82481_), (boolean)true);
            if (tpPos == null) {
                SpawnLookupScheduler.INSTANCE.invalidate(activeKey);
            } else if (tpPos != spawn.m_14419_()) {
                SpawnLookupUtil.changeSpawnCacheValue(activeKey, (ServerLevel)spawn.m_14418_(), tpPos);
            }
        }
    }

    public void resetSpawn(Optional<ConfiguredPower<ModifyPlayerSpawnConfiguration, ModifyPlayerSpawnPower>> configuration, Entity entity, boolean sendToClient) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (configuration.isPresent()) {
                this.getSpawn(configuration.get(), entity, sendToClient);
            } else {
                ((ModifyPlayerSpawnCache)entity).removeActiveSpawnPower();
                if (sendToClient) {
                    ApoliCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new S2CActiveSpawnPowerPacket(Optional.empty()));
                }
            }
        }
    }

    @Nullable
    public Tuple<ResourceKey<ConfiguredPower<?, ?>>, Tuple<ServerLevel, Vec3>> getSpawn(ConfiguredPower<?, ?> configuration, Entity entity, boolean sendToClient) {
        if (!((Boolean)ApoliConfigs.SERVER.separateSpawnFindingThread.get()).booleanValue()) {
            Optional key = ApoliAPI.getPowers().m_7854_(configuration);
            if (key.isPresent()) {
                ResourceKey power = (ResourceKey)key.get();
                try {
                    SpawnLookupScheduler.INSTANCE.requestSpawn(power).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
                Tuple<ServerLevel, Vec3> cachedSpawn = SpawnLookupUtil.getSpawnCache(power);
                if (cachedSpawn != null) {
                    return new Tuple((Object)power, cachedSpawn);
                }
            }
            return null;
        }
        if (entity instanceof ServerPlayer) {
            Tuple<ServerLevel, Vec3> activeSpawn;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            @Nullable ResourceKey<ConfiguredPower<?, ?>> otherKey = ((ModifyPlayerSpawnCache)entity).getActiveSpawnPower();
            if (otherKey != null && (activeSpawn = SpawnLookupUtil.getSpawnCache(otherKey)) != null && ApoliAPI.getPowerContainer(entity).hasPower(otherKey)) {
                return new Tuple(otherKey, activeSpawn);
            }
            Optional key = ApoliAPI.getPowers().m_7854_(configuration);
            if (key.isPresent()) {
                ((ModifyPlayerSpawnCache)serverPlayer).setActiveSpawnPower((ResourceKey)key.get());
                SpawnLookupScheduler.INSTANCE.requestSpawn((ResourceKey)key.get());
                if (sendToClient) {
                    ApoliCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new S2CActiveSpawnPowerPacket(key));
                }
                if (SpawnLookupUtil.getSpawnCache((ResourceKey)key.get()) != null) {
                    return new Tuple((Object)((ResourceKey)key.get()), SpawnLookupUtil.getSpawnCache((ResourceKey)key.get()));
                }
            }
        }
        return null;
    }

    @Override
    public void onAdded(ConfiguredPower<ModifyPlayerSpawnConfiguration, ?> configuration, Entity entity) {
        ServerPlayer serverPlayer;
        if (((Boolean)ApoliConfigs.SERVER.separateSpawnFindingThread.get()).booleanValue() && entity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)entity).m_21224_() && ((ModifyPlayerSpawnCache)entity).getActiveSpawnPower() == null) {
            this.getSpawn(configuration, entity, true);
        }
    }

    @Override
    public void onRemoved(ConfiguredPower<ModifyPlayerSpawnConfiguration, ?> configuration, Entity entity) {
        ServerPlayer serverPlayer;
        if (entity instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)entity).m_9232_() && serverPlayer.m_8961_() != null && serverPlayer.m_8964_()) {
            serverPlayer.m_9158_(Level.f_46428_, null, 0.0f, false, false);
        }
    }

    public void tick(Entity entity) {
        if (((Boolean)ApoliConfigs.SERVER.separateSpawnFindingThread.get()).booleanValue() && entity instanceof ModifyPlayerSpawnCache) {
            ModifyPlayerSpawnCache cache = (ModifyPlayerSpawnCache)entity;
            if (entity instanceof ServerPlayer) {
                ServerPlayer spe = (ServerPlayer)entity;
                if (cache.getActiveSpawnPower() != null) {
                    IPowerContainer.get(entity).ifPresent(container -> {
                        if (!container.hasPower(cache.getActiveSpawnPower()) || !container.getPower(cache.getActiveSpawnPower()).m_203633_() || ApoliAPI.getPowers().m_142003_(cache.getActiveSpawnPower()) && !((ConfiguredPower)ApoliAPI.getPowers().m_6246_(cache.getActiveSpawnPower())).isConfigurationValid() || ApoliAPI.getPowers().m_142003_(cache.getActiveSpawnPower()) && !((ConfiguredPower)ApoliAPI.getPowers().m_6246_(cache.getActiveSpawnPower())).isActive(entity)) {
                            Optional<ConfiguredPower<ModifyPlayerSpawnConfiguration, ModifyPlayerSpawnPower>> optional = container.getPowers((ModifyPlayerSpawnPower)ApoliPowers.MODIFY_PLAYER_SPAWN.get()).stream().filter(Holder::m_203633_).map(Holder::m_203334_).findFirst();
                            this.resetSpawn(optional, entity, spe.m_21224_());
                        }
                    });
                }
            }
        }
    }

    public void schedulePlayerToSpawn(ServerPlayer player) {
        PLAYERS_TO_RESPAWN.add(player);
    }

    @Override
    public void onRespawn(ConfiguredPower<ModifyPlayerSpawnConfiguration, ?> configuration, Entity entity) {
        ServerPlayer player;
        if (entity instanceof ServerPlayer && PLAYERS_TO_RESPAWN.contains(player = (ServerPlayer)entity) && player.m_8961_() == null) {
            this.teleportToModifiedSpawn(configuration, entity);
            PLAYERS_TO_RESPAWN.remove(player);
        }
    }
}

