/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.apace100.apoli.Apoli;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.KeepInventoryConfiguration;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class KeepInventoryPower
extends PowerFactory<KeepInventoryConfiguration> {
    public KeepInventoryPower() {
        super(KeepInventoryConfiguration.CODEC);
    }

    private NonNullList<ItemStack> access(ConfiguredPower<KeepInventoryConfiguration, ?> power, IPowerContainer container) {
        return (NonNullList)power.getPowerData(container, NonNullList::m_122779_);
    }

    private NonNullList<ItemStack> access(ConfiguredPower<KeepInventoryConfiguration, ?> power, Entity entity) {
        return (NonNullList)power.getPowerData(entity, NonNullList::m_122779_);
    }

    public void captureItems(ConfiguredPower<KeepInventoryConfiguration, ?> power, Player player) {
        NonNullList<ItemStack> access = this.access(power, (Entity)player);
        access.clear();
        KeepInventoryConfiguration config = power.getConfiguration();
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (config.isApplicableTo(i, player.m_9236_(), stack) && !EnchantmentHelper.m_44924_((ItemStack)stack)) {
                access.add((Object)stack);
                inventory.m_6836_(i, ItemStack.f_41583_);
                continue;
            }
            access.add((Object)ItemStack.f_41583_);
        }
    }

    public void restoreItems(ConfiguredPower<KeepInventoryConfiguration, ?> power, Player player) {
        Inventory inventory = player.m_150109_();
        NonNullList<ItemStack> access = this.access(power, (Entity)player);
        if (access == null || access.isEmpty()) {
            Apoli.LOGGER.error(KeepInventoryPower.class.getSimpleName() + ": Tried to restore items without having saved any on entity \"" + player.m_7755_().getString() + "\". Power may not have functioned correctly.");
            return;
        }
        if (inventory.m_6643_() != access.size()) {
            Apoli.LOGGER.error(KeepInventoryPower.class.getSimpleName() + ": Tried to restore items with differently sized inventory on entity \"" + player.m_7755_().getString() + "\". Items may have been lost.");
        }
        for (int i = 0; i < inventory.m_6643_() && i < access.size(); ++i) {
            if (((ItemStack)access.get(i)).m_41619_()) continue;
            inventory.m_6836_(i, (ItemStack)access.get(i));
        }
        access.clear();
    }

    @Override
    public void serialize(ConfiguredPower<KeepInventoryConfiguration, ?> configuration, IPowerContainer container, CompoundTag tag) {
        ContainerHelper.m_18973_((CompoundTag)tag, this.access(configuration, container));
    }

    @Override
    public void deserialize(ConfiguredPower<KeepInventoryConfiguration, ?> configuration, IPowerContainer container, CompoundTag tag) {
        NonNullList<ItemStack> access = this.access(configuration, container);
        while (access.size() <= 40) {
            access.add((Object)ItemStack.f_41583_);
        }
        ContainerHelper.m_18980_((CompoundTag)tag, access);
    }
}

