/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import io.github.edwinmindcraft.apoli.api.power.IInventoryPower;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.InventoryConfiguration;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;

public class InventoryPower
extends PowerFactory<InventoryConfiguration>
implements IInventoryPower<InventoryConfiguration>,
IActivePower<InventoryConfiguration> {
    public static void tryDropItemsOnDeath(ConfiguredPower<InventoryConfiguration, InventoryPower> configured, Player player) {
        if (configured.getFactory().shouldDropOnDeath(configured, (Entity)player)) {
            Container container = configured.getFactory().getInventory(configured, (Entity)player);
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack itemStack = container.m_8020_(i);
                if (!configured.getFactory().shouldDropOnDeath(configured, (Entity)player, itemStack)) continue;
                if (!itemStack.m_41619_() && EnchantmentHelper.m_44924_((ItemStack)itemStack)) {
                    container.m_8016_(i);
                    continue;
                }
                player.m_7197_(itemStack, true, false);
                container.m_6836_(i, ItemStack.f_41583_);
            }
        }
    }

    public InventoryPower() {
        super(InventoryConfiguration.CODEC);
    }

    @Override
    public void activate(ConfiguredPower<InventoryConfiguration, ?> configuration, Entity player) {
        if (!player.m_9236_().m_5776_() && player instanceof Player) {
            Player ple = (Player)player;
            if (configuration.isActive(player)) {
                ple.m_5893_((MenuProvider)new SimpleMenuProvider(this.getMenuCreator(configuration, player), (Component)Component.m_237115_((String)configuration.getConfiguration().inventoryName())));
            }
        }
    }

    @Override
    public IActivePower.Key getKey(ConfiguredPower<InventoryConfiguration, ?> configuration, @Nullable Entity player) {
        return configuration.getConfiguration().key();
    }

    @Override
    public boolean shouldDropOnDeath(ConfiguredPower<InventoryConfiguration, ?> configuration, Entity player, ItemStack stack) {
        return this.shouldDropOnDeath(configuration, player) && ConfiguredItemCondition.check(configuration.getConfiguration().dropFilter(), player.m_9236_(), stack);
    }

    @Override
    public boolean shouldDropOnDeath(ConfiguredPower<InventoryConfiguration, ?> configuration, Entity player) {
        return configuration.getConfiguration().dropOnDeath();
    }

    @Override
    public Container getInventory(ConfiguredPower<InventoryConfiguration, ?> configuration, Entity player) {
        return this.getData(configuration, (Entity)player).container;
    }

    @Override
    public MenuConstructor getMenuCreator(ConfiguredPower<InventoryConfiguration, ?> configuration, Entity player) {
        return this.getData(configuration, player).getMenuCreator();
    }

    public int getSize(ConfiguredPower<InventoryConfiguration, ?> configuration, Entity player) {
        return this.getData(configuration, (Entity)player).size;
    }

    public void tryDropItemsOnLost(ConfiguredPower<InventoryConfiguration, InventoryPower> configured, Entity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        for (int i = 0; i < this.getSize(configured, entity); ++i) {
            ItemStack currentItemStack = configured.getFactory().getInventory(configured, (Entity)player).m_8020_(i);
            player.m_150109_().m_150079_(currentItemStack);
        }
    }

    protected DataContainer getData(ConfiguredPower<InventoryConfiguration, ?> configuration, IPowerContainer player) {
        return (DataContainer)configuration.getPowerData(player, () -> new DataContainer((InventoryConfiguration)configuration.getConfiguration()));
    }

    protected DataContainer getData(ConfiguredPower<InventoryConfiguration, ?> configuration, Entity player) {
        return (DataContainer)configuration.getPowerData(player, () -> new DataContainer((InventoryConfiguration)configuration.getConfiguration()));
    }

    @Override
    public void serialize(ConfiguredPower<InventoryConfiguration, ?> configuration, IPowerContainer container, CompoundTag tag) {
        this.getData(configuration, container).serialize(tag);
    }

    @Override
    public void deserialize(ConfiguredPower<InventoryConfiguration, ?> configuration, IPowerContainer container, CompoundTag tag) {
        this.getData(configuration, container).deserialize(tag);
    }

    @Override
    public void onLost(ConfiguredPower<InventoryConfiguration, ?> configuration, Entity entity) {
        if (configuration.getConfiguration().recoverable()) {
            this.tryDropItemsOnLost(configuration, entity);
        }
    }

    public static class DataContainer {
        private final int size;
        private final Function<Container, MenuConstructor> handler;
        private final SimpleContainer container;

        public DataContainer(InventoryConfiguration configuration) {
            switch (configuration.containerType()) {
                case DOUBLE_CHEST: {
                    this.size = 54;
                    this.handler = inventory -> (i, playerInv, invPlayer) -> new ChestMenu(MenuType.f_39962_, i, playerInv, inventory, 6);
                    break;
                }
                case CHEST: {
                    this.size = 27;
                    this.handler = inventory -> (i, playerInv, invPlayer) -> new ChestMenu(MenuType.f_39959_, i, playerInv, inventory, 3);
                    break;
                }
                case HOPPER: {
                    this.size = 5;
                    this.handler = inventory -> (i, playerInv, invPlayer) -> new HopperMenu(i, playerInv, inventory);
                    break;
                }
                default: {
                    this.size = 9;
                    this.handler = inventory -> (i, playerInv, invPlayer) -> new DispenserMenu(i, playerInv, inventory);
                }
            }
            this.container = new SimpleContainer(this.size);
        }

        public MenuConstructor getMenuCreator() {
            return this.handler.apply((Container)this.container);
        }

        public void serialize(CompoundTag tag) {
            NonNullList stacks = NonNullList.m_122780_((int)this.container.m_6643_(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < this.container.m_6643_(); ++i) {
                stacks.set(i, (Object)this.container.m_8020_(i));
            }
            ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)stacks);
        }

        public void deserialize(CompoundTag tag) {
            NonNullList stacks = NonNullList.m_122780_((int)this.container.m_6643_(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)stacks);
            for (int i = 0; i < this.container.m_6643_(); ++i) {
                this.container.m_6836_(i, (ItemStack)stacks.get(i));
            }
        }

        public void createHandler(InventoryConfiguration configuration) {
        }
    }

    public static enum ContainerType {
        CHEST,
        DOUBLE_CHEST,
        DROPPER,
        DISPENSER,
        HOPPER;

    }
}

