/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.ColorConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.EntityGlowConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;

public class EntityGlowPower
extends PowerFactory<EntityGlowConfiguration> {
    private final boolean targetSelf;

    private static Stream<Holder<ConfiguredPower<EntityGlowConfiguration, EntityGlowPower>>> getGlowPowers(Entity actor, Entity target, boolean isPlayer) {
        List selfGlow = IPowerContainer.getPowers(target, (EntityGlowPower)ApoliPowers.SELF_GLOW.get());
        if (isPlayer) {
            return selfGlow.stream();
        }
        List entityGlow = IPowerContainer.getPowers(actor, (EntityGlowPower)ApoliPowers.ENTITY_GLOW.get());
        return Stream.concat(entityGlow.stream(), selfGlow.stream());
    }

    public static boolean shouldGlow(Entity actor, Entity target, boolean isPlayer) {
        return EntityGlowPower.getGlowPowers(actor, target, isPlayer).anyMatch(x -> ((EntityGlowPower)((ConfiguredPower)x.m_203334_()).getFactory()).doesApply((EntityGlowConfiguration)((ConfiguredPower)x.m_203334_()).getConfiguration(), actor, target));
    }

    public static Optional<ColorConfiguration> getGlowColor(Entity actor, Entity target) {
        return EntityGlowPower.getGlowPowers(actor, target, false).flatMap(x -> ((EntityGlowPower)((ConfiguredPower)x.m_203334_()).getFactory()).getColor((EntityGlowConfiguration)((ConfiguredPower)x.m_203334_()).getConfiguration(), actor, target).stream()).findFirst();
    }

    public EntityGlowPower(boolean targetSelf) {
        super(EntityGlowConfiguration.CODEC);
        this.targetSelf = targetSelf;
    }

    public boolean doesApply(EntityGlowConfiguration configuration, Entity actor, Entity target) {
        return configuration.applyChecks(actor, target, this.targetSelf);
    }

    public Optional<ColorConfiguration> getColor(EntityGlowConfiguration configuration, Entity actor, Entity target) {
        if (this.doesApply(configuration, actor, target) && !configuration.useTeams()) {
            return Optional.of(configuration.color());
        }
        return Optional.empty();
    }
}

