/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.ElytraFlightConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import top.theillusivec4.caelus.api.CaelusApi;

public class ElytraFlightPower
extends PowerFactory<ElytraFlightConfiguration> {
    public static final AttributeModifier FLIGHT_MODIFIER = new AttributeModifier(UUID.fromString("29eb14ca-c803-4af6-81e2-86e9bf1d4857"), "Elytra modifier", 1.0, AttributeModifier.Operation.ADDITION);

    public static boolean shouldRenderElytra(Entity entity) {
        return IPowerContainer.getPowers(entity, (ElytraFlightPower)ApoliPowers.ELYTRA_FLIGHT.get()).stream().anyMatch(x -> ((ElytraFlightConfiguration)((ConfiguredPower)x.m_203334_()).getConfiguration()).render());
    }

    public static Optional<ResourceLocation> getElytraTexture(Entity entity) {
        return IPowerContainer.getPowers(entity, (ElytraFlightPower)ApoliPowers.ELYTRA_FLIGHT.get()).stream().map(x -> ((ElytraFlightConfiguration)((ConfiguredPower)x.m_203334_()).getConfiguration()).texture()).filter(Objects::nonNull).findFirst();
    }

    public static void enableFlight(Entity entity) {
        AttributeInstance attributeInstance;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (living.m_21204_().m_22171_(CaelusApi.getInstance().getFlightAttribute()) && !(attributeInstance = living.m_21051_(CaelusApi.getInstance().getFlightAttribute())).m_22109_(FLIGHT_MODIFIER)) {
            attributeInstance.m_22118_(FLIGHT_MODIFIER);
        }
    }

    public static void disableFlight(Entity entity) {
        AttributeInstance attributeInstance;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (living.m_21204_().m_22171_(CaelusApi.getInstance().getFlightAttribute()) && (attributeInstance = living.m_21051_(CaelusApi.getInstance().getFlightAttribute())).m_22109_(FLIGHT_MODIFIER)) {
            attributeInstance.m_22130_(FLIGHT_MODIFIER);
        }
    }

    public ElytraFlightPower() {
        super(ElytraFlightConfiguration.CODEC);
        this.ticking(true);
    }

    @Override
    public void tick(ConfiguredPower<ElytraFlightConfiguration, ?> configuration, Entity player) {
        if (configuration.isActive(player)) {
            ElytraFlightPower.enableFlight(player);
        } else {
            ElytraFlightPower.disableFlight(player);
        }
    }

    @Override
    protected void onRemoved(ElytraFlightConfiguration configuration, Entity entity) {
        ElytraFlightPower.disableFlight(entity);
    }
}

