/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.ClimbingConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ClimbingPower
extends PowerFactory<ClimbingConfiguration> {
    public static boolean check(LivingEntity player, Consumer<BlockPos> climbingPosSetter) {
        List climbingPowers = IPowerContainer.get((Entity)player).map(x -> x.getPowers((ClimbingPower)ApoliPowers.CLIMBING.get(), true).stream().map(Holder::m_203334_)).orElseGet(() -> Stream.of(new ConfiguredPower[0])).toList();
        if (climbingPowers.size() > 0) {
            if (climbingPowers.stream().anyMatch(x -> x.isActive((Entity)player))) {
                climbingPosSetter.accept(player.m_20183_());
                return true;
            }
            return player.m_5791_() && climbingPowers.stream().anyMatch(x -> ((ClimbingPower)x.getFactory()).canHold((ConfiguredPower<ClimbingConfiguration, ?>)x, (Entity)player));
        }
        return false;
    }

    public ClimbingPower() {
        super(ClimbingConfiguration.CODEC);
    }

    public boolean canHold(ConfiguredPower<ClimbingConfiguration, ?> configuration, Entity player) {
        Holder<ConfiguredEntityCondition<?, ?>> holdingCondition = configuration.getConfiguration().condition();
        return configuration.getConfiguration().allowHolding() && (holdingCondition == null || !holdingCondition.m_203633_() ? configuration.isActive(player) : ((ConfiguredEntityCondition)holdingCondition.m_203334_()).check(player));
    }
}

