/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.ActionOverTimeConfiguration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;

public class ActionOverTimePower
extends PowerFactory<ActionOverTimeConfiguration> {
    public ActionOverTimePower() {
        super(ActionOverTimeConfiguration.CODEC);
        this.ticking(true);
    }

    @Override
    public void tick(ConfiguredPower<ActionOverTimeConfiguration, ?> configuration, Entity player) {
        AtomicBoolean data = (AtomicBoolean)configuration.getPowerData(player, () -> new AtomicBoolean(false));
        ActionOverTimeConfiguration config = configuration.getConfiguration();
        if (configuration.isActive(player)) {
            if (!data.get()) {
                ConfiguredEntityAction.execute(config.risingAction(), player);
            }
            ConfiguredEntityAction.execute(config.entityAction(), player);
            data.set(true);
        } else {
            if (data.get()) {
                ConfiguredEntityAction.execute(config.fallingAction(), player);
            }
            data.set(false);
        }
    }

    @Override
    protected int tickInterval(ActionOverTimeConfiguration configuration, Entity player) {
        return configuration.interval();
    }

    @Override
    public void serialize(ConfiguredPower<ActionOverTimeConfiguration, ?> configuration, IPowerContainer container, CompoundTag tag) {
        tag.m_128379_("WasActive", ((AtomicBoolean)configuration.getPowerData(container, () -> new AtomicBoolean(false))).get());
    }

    @Override
    public void deserialize(ConfiguredPower<ActionOverTimeConfiguration, ?> configuration, IPowerContainer container, CompoundTag tag) {
        AtomicBoolean data = (AtomicBoolean)configuration.getPowerData(container, () -> new AtomicBoolean(false));
        data.set(!Objects.equals(tag.m_128423_("WasActive"), ByteTag.f_128256_));
    }
}

