/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.network;

import io.github.apace100.apoli.Apoli;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record S2CPlayerMount(int entity, int vehicle) {
    public static S2CPlayerMount decode(FriendlyByteBuf buffer) {
        return new S2CPlayerMount(buffer.readInt(), buffer.readInt());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entity());
        buffer.writeInt(this.vehicle());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleSync() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(this.entity());
        Entity vehicle = level.m_6815_(this.vehicle());
        if (entity == null) {
            Apoli.LOGGER.warn("Received passenger for unknown player");
        } else if (vehicle == null) {
            Apoli.LOGGER.warn("Received unknown passenger for player");
        } else if (entity.m_7998_(vehicle, true)) {
            Apoli.LOGGER.info("{} started riding {}", (Object)entity.m_5446_().getString(), (Object)vehicle.m_5446_().getString());
        } else {
            Apoli.LOGGER.warn("{} failed to start riding {}", (Object)entity.m_5446_().getString(), (Object)vehicle.m_5446_().getString());
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::handleSync));
        contextSupplier.get().setPacketHandled(true);
    }
}

