/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.network;

import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.apoli.common.util.SpawnLookupUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record S2CCachedSpawnsPacket(Set<ResourceKey<ConfiguredPower<?, ?>>> powers, boolean shouldRemove) {
    public S2CCachedSpawnsPacket(Set<ResourceKey<ConfiguredPower<?, ?>>> powers) {
        this(powers, false);
    }

    public static S2CCachedSpawnsPacket decode(FriendlyByteBuf buf) {
        HashSet powers = new HashSet();
        int powerSize = buf.readInt();
        for (int i = 0; i < powerSize; ++i) {
            powers.add(buf.m_236801_(ApoliDynamicRegistries.CONFIGURED_POWER_KEY));
        }
        boolean shouldRemove = buf.readBoolean();
        return new S2CCachedSpawnsPacket(powers, shouldRemove);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.powers().size());
        this.powers().forEach(arg_0 -> ((FriendlyByteBuf)buf).m_236858_(arg_0));
        buf.writeBoolean(this.shouldRemove());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleSync() {
        if (this.shouldRemove()) {
            this.powers().forEach(SpawnLookupUtil::clearSpawnCacheValue);
        } else {
            this.powers().forEach(SpawnLookupUtil::addToPowersWithSpawns);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::handleSync));
        contextSupplier.get().setPacketHandled(true);
    }
}

