/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.network;

import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.apoli.common.util.ModifyPlayerSpawnCache;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record S2CActiveSpawnPowerPacket(Optional<ResourceKey<ConfiguredPower<?, ?>>> power) {
    public static S2CActiveSpawnPowerPacket decode(FriendlyByteBuf buf) {
        Optional<ResourceKey<ConfiguredPower<?, ?>>> power = Optional.empty();
        if (buf.readBoolean()) {
            power = Optional.of(buf.m_236801_(ApoliDynamicRegistries.CONFIGURED_POWER_KEY));
        }
        return new S2CActiveSpawnPowerPacket(power);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.power().isPresent());
        if (this.power().isPresent()) {
            buf.m_236858_(this.power().get());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleSync() {
        ((ModifyPlayerSpawnCache)Minecraft.m_91087_().f_91074_).setActiveSpawnPower(this.power().orElse(null));
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::handleSync));
        contextSupplier.get().setPacketHandled(true);
    }
}

