/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.apace100.apoli.Apoli;
import io.github.edwinmindcraft.apoli.common.global.GlobalPowerSet;
import io.github.edwinmindcraft.calio.api.registry.DynamicEntryFactory;
import io.github.edwinmindcraft.calio.api.registry.DynamicEntryValidator;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public enum GlobalPowerSetLoader implements DynamicEntryFactory<GlobalPowerSet>,
DynamicEntryValidator<GlobalPowerSet>
{
    INSTANCE;

    private static final Comparator<GlobalPowerSet> LOADING_ORDER_COMPARATOR;

    public GlobalPowerSet accept(@NotNull ResourceLocation resourceLocation, @NotNull List<JsonElement> list) {
        Optional<GlobalPowerSet> definition = list.stream().flatMap(x -> {
            DataResult power = GlobalPowerSet.CODEC.decode((DynamicOps)JsonOps.INSTANCE, x).map(Pair::getFirst);
            Optional powerDefinition = power.resultOrPartial(error -> {});
            if (power.error().isPresent()) {
                if (powerDefinition.isEmpty()) {
                    Apoli.LOGGER.error("Error loading global power set \"{}\": {}", (Object)resourceLocation, (Object)((DataResult.PartialResult)power.error().get()).message());
                    return Stream.empty();
                }
                Apoli.LOGGER.warn("Global Power Set \"{}\" will only be partially loaded: {}", (Object)resourceLocation, (Object)((DataResult.PartialResult)power.error().get()).message());
            }
            return powerDefinition.stream();
        }).max(LOADING_ORDER_COMPARATOR);
        if (definition.isEmpty()) {
            Apoli.LOGGER.error("Loading for all instances of global power set {} failed.", (Object)resourceLocation);
        }
        return definition.orElse(null);
    }

    @NotNull
    public Map<ResourceLocation, GlobalPowerSet> create(ResourceLocation location, @NotNull List<JsonElement> entries) {
        Object accept = this.accept(location, (List)entries);
        if (accept != null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)location, accept);
            return builder.build();
        }
        return ImmutableMap.of();
    }

    @NotNull
    public DataResult<GlobalPowerSet> validate(@NotNull ResourceLocation location, @NotNull GlobalPowerSet globalPowerSet, @NotNull ICalioDynamicRegistryManager manager) {
        return DataResult.success((Object)globalPowerSet);
    }

    static {
        LOADING_ORDER_COMPARATOR = Comparator.comparingInt(GlobalPowerSet::order);
    }
}

