/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.condition.entity;

import com.mojang.serialization.MapCodec;
import io.github.edwinmindcraft.apoli.api.configuration.FieldConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityCondition;
import java.util.function.BiPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SingleFieldEntityCondition<T>
extends EntityCondition<FieldConfiguration<T>> {
    private final BiPredicate<Entity, T> predicate;

    public static boolean checkPredicate(Entity entity, ResourceLocation identifier) {
        LootItemCondition lootCondition;
        MinecraftServer server = entity.m_9236_().m_7654_();
        if (server != null && (lootCondition = (LootItemCondition)server.m_278653_().m_278789_(LootDataType.f_278407_, identifier)) != null) {
            LootParams lootBuilder = new LootParams.Builder((ServerLevel)entity.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_287289_(LootContextParams.f_81455_, (Object)entity).m_287235_(LootContextParamSets.f_81412_);
            return lootCondition.test((Object)new LootContext.Builder(lootBuilder).m_287259_(null));
        }
        return false;
    }

    public static boolean nbt(Entity entity, CompoundTag compoundTag) {
        CompoundTag tag = new CompoundTag();
        entity.m_20223_(tag);
        return NbtUtils.m_129235_((Tag)compoundTag, (Tag)tag, (boolean)true);
    }

    public SingleFieldEntityCondition(MapCodec<T> codec, BiPredicate<Entity, T> predicate) {
        super(FieldConfiguration.codec(codec));
        this.predicate = predicate;
    }

    @Override
    public boolean check(FieldConfiguration<T> configuration, Entity entity) {
        return this.predicate.test(entity, (Entity)configuration.value());
    }
}

