/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.condition.entity;

import io.github.apace100.apoli.mixin.EntityAccessor;
import io.github.edwinmindcraft.apoli.api.configuration.NoConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityCondition;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;

public class SimpleEntityCondition
extends EntityCondition<NoConfiguration> {
    private final Predicate<Entity> predicate;

    public static SimpleEntityCondition of(Predicate<Player> predicate) {
        return new SimpleEntityCondition(living -> {
            Player pe;
            return living instanceof Player && predicate.test(pe = (Player)living);
        });
    }

    public static boolean isExposedToSky(Entity entity) {
        BlockPos bp = new BlockPos(entity.m_20183_().m_123341_(), (int)Math.round(entity.m_20186_()), entity.m_20183_().m_123343_());
        if (entity.m_20202_() instanceof Boat) {
            bp = bp.m_7494_();
        }
        return entity.m_9236_().m_45527_(bp);
    }

    public static boolean isExposedToSun(Entity entity) {
        return entity.m_213856_() > 0.5f && entity.m_9236_().m_46461_() && !((EntityAccessor)entity).callIsBeingRainedOn() && SimpleEntityCondition.isExposedToSky(entity);
    }

    public static boolean isGlowing(Entity entity) {
        if (entity.m_9236_().m_5776_()) {
            return Minecraft.m_91087_().m_91314_(entity);
        }
        return entity.m_142038_();
    }

    public SimpleEntityCondition(Predicate<Entity> predicate) {
        super(NoConfiguration.CODEC);
        this.predicate = predicate;
    }

    @Override
    public boolean check(NoConfiguration configuration, Entity entity) {
        return this.predicate.test(entity);
    }
}

