/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.condition.entity;

import io.github.apace100.apoli.util.Shape;
import io.github.edwinmindcraft.apoli.api.power.ConditionData;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.configuration.BlockInRadiusConfiguration;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraftforge.common.util.NonNullSupplier;
import org.apache.commons.lang3.mutable.MutableInt;

public class BlockInRadiusCondition
extends EntityCondition<BlockInRadiusConfiguration> {
    public BlockInRadiusCondition() {
        super(BlockInRadiusConfiguration.CODEC);
    }

    @Override
    public boolean check(BlockInRadiusConfiguration configuration, Entity entity) {
        int stopAt = configuration.comparison().getOptimalStoppingPoint();
        MutableInt count = new MutableInt(0);
        BooleanSupplier stopping = () -> count.intValue() >= stopAt;
        int radius = configuration.radius();
        BlockPos lowerCorner = entity.m_20183_().m_7918_(-radius, -radius, -radius);
        BlockPos upperCorner = entity.m_20183_().m_7918_(radius, radius, radius);
        int xStart = lowerCorner.m_123341_() >> 4;
        int xEnd = upperCorner.m_123341_() >> 4;
        int yStart = lowerCorner.m_123342_() >> 4;
        int yEnd = upperCorner.m_123342_() >> 4;
        int zStart = lowerCorner.m_123343_() >> 4;
        int zEnd = upperCorner.m_123343_() >> 4;
        int xSize = xEnd - xStart + 1;
        int ySize = yEnd - yStart + 1;
        int zSize = zEnd - zStart + 1;
        LevelChunkSection[] sections = new LevelChunkSection[xSize * ySize * zSize];
        for (int x = xStart; x <= xEnd; ++x) {
            for (int z = zStart; z <= zEnd; ++z) {
                LevelChunk chunk = entity.m_9236_().m_6325_(x, z);
                LevelChunkSection[] chunkSections = chunk.m_7103_();
                for (int y = yStart; y <= yEnd; ++y) {
                    int sectionIndex = chunk.m_151564_(y << 4);
                    int index = y - yStart + (x - xStart + xSize * (z - zStart)) * ySize;
                    sections[index] = sectionIndex >= 0 & sectionIndex < chunkSections.length ? chunkSections[sectionIndex] : null;
                }
            }
        }
        Shape.forPositions(entity.m_20183_(), configuration.shape(), radius, pos -> {
            int x = pos.m_123341_() >> 4;
            int y = pos.m_123342_() >> 4;
            int z = pos.m_123343_() >> 4;
            LevelChunkSection section = sections[y - yStart + (x - xStart + xSize * (z - zStart)) * ySize];
            if (ConfiguredBlockCondition.check(configuration.blockCondition(), (LevelReader)entity.m_9236_(), pos, (NonNullSupplier<BlockState>)((NonNullSupplier)() -> section == null ? Blocks.f_50626_.m_49966_() : section.m_62982_(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF)))) {
                count.increment();
            }
        }, stopping);
        return configuration.comparison().check(count.intValue());
    }

    @Override
    public boolean check(BlockInRadiusConfiguration configuration, ConditionData data, Entity entity) {
        if (data.inverted()) {
            return this.check(configuration.inverse(), entity);
        }
        return this.check(configuration, entity);
    }
}

