/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.component;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.global.GlobalPowerSetUtil;
import io.github.apace100.apoli.util.GainedPowerCriterion;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.apoli.common.registry.ApoliCapabilities;
import io.github.edwinmindcraft.calio.api.CalioAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowerContainer
implements IPowerContainer,
ICapabilitySerializable<Tag> {
    @NotNull
    private final LivingEntity owner;
    private final Map<ResourceKey<ConfiguredPower<?, ?>>, Holder<ConfiguredPower<?, ?>>> powers;
    private final Map<ResourceKey<ConfiguredPower<?, ?>>, Set<ResourceLocation>> powerSources;
    private final Map<ResourceKey<ConfiguredPower<?, ?>>, Object> powerData;
    private final Map<PowerFactory<?>, List<Holder<ConfiguredPower<?, ?>>>> factoryAccessCache;
    private final transient LazyOptional<IPowerContainer> thisOptional = LazyOptional.of(() -> this);

    public PowerContainer(@NotNull LivingEntity owner) {
        this.owner = owner;
        this.powers = new ConcurrentHashMap();
        this.powerSources = new ConcurrentHashMap();
        this.powerData = new ConcurrentHashMap();
        this.factoryAccessCache = new ConcurrentHashMap();
    }

    @Override
    public void removePower(ResourceKey<ConfiguredPower<?, ?>> power, ResourceLocation source) {
        if (this.powerSources.containsKey(power)) {
            Set<ResourceLocation> sources = this.powerSources.get(power);
            sources.remove(source);
            Holder<ConfiguredPower<?, ?>> instance = this.powers.get(power);
            if (sources.isEmpty()) {
                this.powerSources.remove(power);
                this.powers.remove(power);
                if (instance != null && instance.m_203633_()) {
                    Object factory = ((ConfiguredPower)instance.get()).getFactory();
                    ((ConfiguredPower)instance.m_203334_()).onRemoved((Entity)this.owner);
                    ((ConfiguredPower)instance.m_203334_()).onLost((Entity)this.owner);
                    if (this.factoryAccessCache.containsKey(factory)) {
                        this.factoryAccessCache.get(factory).remove(instance);
                    } else {
                        this.rebuildFactoryAccessCache();
                    }
                } else {
                    this.rebuildFactoryAccessCache();
                }
            }
            if (instance != null && instance.m_203633_()) {
                for (ResourceKey<ConfiguredPower<?, ?>> value : ((ConfiguredPower)instance.m_203334_()).getContainedPowerKeys()) {
                    this.removePower(value, source);
                }
            }
        }
    }

    @Override
    public int removeAllPowersFromSource(ResourceLocation source) {
        List<ResourceKey<ConfiguredPower<?, ?>>> powersFromSource = this.getPowersFromSource(source);
        powersFromSource.forEach(power -> this.removePower((ResourceKey<ConfiguredPower<?, ?>>)power, source));
        return powersFromSource.size();
    }

    @Override
    @NotNull
    public List<ResourceKey<ConfiguredPower<?, ?>>> getPowersFromSource(ResourceLocation source) {
        return this.powerSources.entrySet().stream().filter(x -> ((Set)x.getValue()).contains(source)).map(Map.Entry::getKey).toList();
    }

    @Override
    public boolean addPower(ResourceKey<ConfiguredPower<?, ?>> power, ResourceLocation source) {
        MappedRegistry<ConfiguredPower<?, ?>> powers = ApoliAPI.getPowers(this.owner.m_20194_());
        Optional optionalInstance = powers.m_203636_(power);
        if (optionalInstance.isEmpty() || !((Holder.Reference)optionalInstance.get()).m_203633_()) {
            Apoli.LOGGER.error("Trying to add unregistered power {} to entity {}", power, (Object)this.owner);
            return false;
        }
        Holder instance = (Holder)optionalInstance.get();
        if (this.powerSources.containsKey(power)) {
            Set<ResourceLocation> sources = this.powerSources.get(power);
            if (sources.contains(source)) {
                return false;
            }
            sources.add(source);
            for (ResourceKey<ConfiguredPower<?, ?>> value : ((ConfiguredPower)instance.m_203334_()).getContainedPowerKeys()) {
                Apoli.LOGGER.info("Adding subpower {} from power {}", value, power);
                this.addPower(value, source);
            }
            return true;
        }
        for (ResourceKey<ConfiguredPower<?, ?>> value : ((ConfiguredPower)instance.m_203334_()).getContainedPowerKeys()) {
            Apoli.LOGGER.info("Adding subpower {} from power {}", value, power);
            this.addPower(value, source);
        }
        HashSet sources = new HashSet();
        sources.add(source);
        this.powerSources.put(power, sources);
        this.powers.put(power, instance);
        this.factoryAccessCache.computeIfAbsent((PowerFactory<?>)((ConfiguredPower)instance.m_203334_()).getFactory(), (Function<PowerFactory<?>, List<Holder<ConfiguredPower<?, ?>>>>)((Function<PowerFactory, List>)k -> Collections.synchronizedList(new ArrayList()))).add(instance);
        ((ConfiguredPower)instance.m_203334_()).onGained((Entity)this.owner);
        ((ConfiguredPower)instance.m_203334_()).onAdded((Entity)this.owner);
        LivingEntity livingEntity = this.owner;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer spe = (ServerPlayer)livingEntity;
            ((Optional)instance.m_203439_().map(Optional::of, arg_0 -> powers.m_7854_(arg_0))).ifPresent(key -> GainedPowerCriterion.INSTANCE.trigger(spe, (ResourceKey<ConfiguredPower<?, ?>>)key));
        }
        return true;
    }

    @Override
    public boolean hasPower(@Nullable ResourceKey<ConfiguredPower<?, ?>> power) {
        return power != null && this.powers.containsKey(power);
    }

    @Override
    public boolean hasPower(PowerFactory<?> factory) {
        List<Holder<ConfiguredPower<?, ?>>> access = this.factoryAccessCache.get(factory);
        if (access == null) {
            return false;
        }
        for (Holder<ConfiguredPower<?, ?>> holder : access) {
            if (!holder.m_203633_() || !((ConfiguredPower)holder.m_203334_()).isActive((Entity)this.owner)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPower(ResourceKey<ConfiguredPower<?, ?>> power, ResourceLocation source) {
        return this.powerSources.containsKey(power) && this.powerSources.get(power).contains(source);
    }

    @Override
    @Nullable
    public <C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>> Holder<ConfiguredPower<C, F>> getPower(ResourceKey<ConfiguredPower<?, ?>> power) {
        Holder<ConfiguredPower<?, ?>> holder = this.powers.get(power);
        if (holder != null && holder.m_203633_()) {
            return holder;
        }
        return null;
    }

    @Override
    @NotNull
    public List<Holder<ConfiguredPower<?, ?>>> getPowers() {
        return (List)this.powers.values().stream().filter(Holder::m_203633_).collect(ImmutableList.toImmutableList());
    }

    @Override
    @NotNull
    public Set<ResourceKey<ConfiguredPower<?, ?>>> getPowerTypes(boolean includeSubPowers) {
        if (includeSubPowers) {
            return ImmutableSet.copyOf(this.powers.keySet());
        }
        Set subPowers = this.powers.entrySet().stream().flatMap(x -> ((ConfiguredPower)((Holder)x.getValue()).m_203334_()).getChildrenKeys().stream()).collect(Collectors.toUnmodifiableSet());
        return this.powers.keySet().stream().filter(x -> !subPowers.contains(x)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @NotNull
    public <C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>> List<Holder<ConfiguredPower<C, F>>> getPowers(F factory, @NotNull Predicate<Holder<ConfiguredPower<C, F>>> filter) {
        List<Holder<ConfiguredPower<?, ?>>> access = this.factoryAccessCache.get(factory);
        if (access == null) {
            return ImmutableList.of();
        }
        ArrayList<Holder<ConfiguredPower<C, F>>> result = new ArrayList<Holder<ConfiguredPower<C, F>>>(access.size());
        Iterator<Holder<ConfiguredPower<?, ?>>> iterator = access.iterator();
        while (iterator.hasNext()) {
            Holder<ConfiguredPower<?, ?>> holder;
            Holder<ConfiguredPower<?, ?>> holderCast = holder = iterator.next();
            if (!holder.m_203633_() || !filter.test(holderCast)) continue;
            result.add(holderCast);
        }
        return result;
    }

    @Override
    @NotNull
    public List<ResourceLocation> getSources(ResourceKey<ConfiguredPower<?, ?>> power) {
        return this.powerSources.containsKey(power) ? ImmutableList.copyOf((Collection)this.powerSources.get(power)) : ImmutableList.of();
    }

    @Override
    public void sync() {
        ApoliAPI.synchronizePowerContainer((Entity)this.owner);
    }

    @Override
    public void serverTick() {
        Iterator<Holder<ConfiguredPower<?, ?>>> iterator = this.powers.values().iterator();
        boolean removedAny = false;
        while (iterator.hasNext()) {
            Holder<ConfiguredPower<?, ?>> value = iterator.next();
            if (value.m_203633_()) {
                ((ConfiguredPower)value.m_203334_()).tick((Entity)this.owner);
                continue;
            }
            iterator.remove();
            removedAny = true;
        }
        if (removedAny) {
            this.rebuildFactoryAccessCache();
        }
    }

    @Override
    public void readNbt(CompoundTag tag, boolean applyEvents) {
        try {
            if (applyEvents) {
                for (Holder<ConfiguredPower<?, ?>> power : this.powers.values()) {
                    if (!power.m_203633_()) continue;
                    ((ConfiguredPower)power.m_203334_()).onRemoved((Entity)this.owner);
                    ((ConfiguredPower)power.m_203334_()).onLost((Entity)this.owner);
                }
            }
            this.powers.clear();
            this.powerSources.clear();
            this.powerData.clear();
            ListTag powerList = (ListTag)tag.m_128423_("Powers");
            MappedRegistry<ConfiguredPower<?, ?>> powers = ApoliAPI.getPowers();
            if (powerList != null) {
                for (int i = 0; i < powerList.size(); ++i) {
                    CompoundTag powerTag = powerList.m_128728_(i);
                    ResourceLocation typeKey = ResourceLocation.m_135820_((String)powerTag.m_128461_("Type"));
                    if (typeKey == null) {
                        Apoli.LOGGER.warn("Power key  \"" + powerTag.m_128461_("Type") + "\" was not a valid identifier");
                        continue;
                    }
                    ResourceKey identifier = ResourceKey.m_135785_(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, (ResourceLocation)typeKey);
                    ListTag sources = (ListTag)powerTag.m_128423_("Sources");
                    HashSet list = new HashSet();
                    if (sources != null) {
                        sources.forEach(nbtElement -> list.add(ResourceLocation.m_135820_((String)nbtElement.m_7916_())));
                    }
                    this.powerSources.put(identifier, list);
                    try {
                        CompoundTag data = powerTag.m_128469_("Data");
                        Optional<Holder.Reference> optionalPower = powers.m_203636_(identifier).filter(Holder::m_203633_);
                        if (optionalPower.isEmpty()) {
                            Apoli.LOGGER.warn("Power data of unregistered power \"" + identifier + "\" found on entity, skipping...");
                            continue;
                        }
                        Holder instance = (Holder)optionalPower.get();
                        try {
                            ((ConfiguredPower)instance.m_203334_()).deserialize(this, data);
                        }
                        catch (ClassCastException e) {
                            Apoli.LOGGER.warn("Data type of \"" + identifier + "\" changed, skipping data for that power on entity " + this.owner.m_7755_().m_214077_());
                        }
                        this.powers.put(identifier, instance);
                        if (!applyEvents) continue;
                        ((ConfiguredPower)instance.m_203334_()).onAdded((Entity)this.owner);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        Apoli.LOGGER.warn("Power data of unregistered power \"" + identifier + "\" found on entity, skipping...");
                    }
                }
                for (Map.Entry<ResourceKey<ConfiguredPower<?, ?>>, Set<ResourceLocation>> entry : this.powerSources.entrySet()) {
                    ConfiguredPower power = (ConfiguredPower)powers.m_6246_(entry.getKey());
                    if (power == null) continue;
                    for (ResourceKey<ConfiguredPower<?, ?>> subPower : power.getContainedPowerKeys()) {
                        for (ResourceLocation source : entry.getValue()) {
                            if (this.hasPower(subPower, source)) continue;
                            this.addPower(subPower, source);
                        }
                    }
                }
            }
            this.rebuildFactoryAccessCache();
        }
        catch (Exception e) {
            Apoli.LOGGER.info("Error while reading data: " + e.getMessage());
        }
    }

    private void rebuildFactoryAccessCache() {
        this.factoryAccessCache.clear();
        for (Holder<ConfiguredPower<?, ?>> value : this.powers.values()) {
            if (!value.m_203633_()) continue;
            this.factoryAccessCache.computeIfAbsent((PowerFactory<?>)((ConfiguredPower)value.get()).getFactory(), (Function<PowerFactory<?>, List<Holder<ConfiguredPower<?, ?>>>>)((Function<PowerFactory, List>)k -> Collections.synchronizedList(new ArrayList()))).add(value);
        }
    }

    @Override
    public void rebuildCache() {
        ImmutableSet powers = ImmutableSet.copyOf(this.powers.keySet());
        MappedRegistry<ConfiguredPower<?, ?>> registry = ApoliAPI.getPowers();
        for (ResourceKey power : powers) {
            Optional<Holder.Reference> holder = registry.m_203636_(power).filter(Holder::m_203633_);
            if (holder.isPresent()) {
                this.powers.put(power, (Holder)holder.get());
                continue;
            }
            this.powerSources.get(power).forEach(source -> this.removePower((ResourceKey<ConfiguredPower<?, ?>>)power, (ResourceLocation)source));
            Apoli.LOGGER.warn("Power {} was removed from entity {} as it doesn't exist anymore.", (Object)power, (Object)this.owner.m_6302_());
        }
        this.rebuildFactoryAccessCache();
    }

    @Override
    public void handle(Multimap<ResourceLocation, ResourceLocation> powerSources, Map<ResourceLocation, CompoundTag> data) {
        this.powerSources.clear();
        this.powers.clear();
        this.powerData.clear();
        MappedRegistry powerRegistry = CalioAPI.getDynamicRegistries((MinecraftServer)this.owner.m_20194_()).get(ApoliDynamicRegistries.CONFIGURED_POWER_KEY);
        for (Map.Entry powerEntry : powerSources.asMap().entrySet()) {
            ResourceKey power = ResourceKey.m_135785_(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, (ResourceLocation)((ResourceLocation)powerEntry.getKey()));
            Optional<Holder.Reference> configuredPower = powerRegistry.m_203636_(power).filter(Holder::m_203633_);
            if (configuredPower.isEmpty()) {
                Apoli.LOGGER.warn("Received missing power {} from server for entity {}", (Object)power, (Object)this.owner.m_6302_());
                continue;
            }
            this.powers.put(power, (Holder)configuredPower.get());
            this.powerSources.put(power, new HashSet((Collection)powerEntry.getValue()));
            CompoundTag tag = data.get(powerEntry.getKey());
            if (tag == null) continue;
            ((ConfiguredPower)configuredPower.get().m_203334_()).deserialize(this, tag);
        }
        this.rebuildFactoryAccessCache();
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        ListTag powerList = new ListTag();
        for (Map.Entry<ResourceKey<ConfiguredPower<?, ?>>, Holder<ConfiguredPower<?, ?>>> powerEntry : this.powers.entrySet()) {
            CompoundTag powerTag = new CompoundTag();
            powerTag.m_128359_("Type", powerEntry.getKey().m_135782_().toString());
            powerTag.m_128365_("Data", (Tag)((ConfiguredPower)powerEntry.getValue().m_203334_()).serialize(this));
            ListTag sources = new ListTag();
            this.powerSources.get(powerEntry.getKey()).forEach(id -> sources.add((Object)StringTag.m_129297_((String)id.toString())));
            powerTag.m_128365_("Sources", (Tag)sources);
            powerList.add((Object)powerTag);
        }
        tag.m_128365_("Powers", (Tag)powerList);
        return tag;
    }

    @Override
    @NotNull
    public <T> T getPowerData(ResourceKey<ConfiguredPower<?, ?>> power, NonNullSupplier<? extends T> supplier) {
        Object obj = this.powerData.computeIfAbsent(power, x -> supplier.get());
        try {
            return (T)obj;
        }
        catch (ClassCastException e) {
            return (T)this.powerData.put(power, supplier.get());
        }
    }

    @Override
    public Entity getOwner() {
        return this.owner;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return ApoliCapabilities.POWER_CONTAINER.orEmpty(cap, this.thisOptional);
    }

    public Tag serializeNBT() {
        return this.writeToNbt(new CompoundTag());
    }

    public void deserializeNBT(Tag nbt) {
        this.readFromNbt((CompoundTag)nbt);
        GlobalPowerSetUtil.applyGlobalPowers((Entity)this.owner);
    }
}

