/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.action.configuration;

import io.github.apace100.apoli.power.factory.condition.DistanceFromCoordinatesConditionRegistry;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ReferencePoint {
    PLAYER_SPAWN,
    PLAYER_NATURAL_SPAWN,
    WORLD_SPAWN,
    WORLD_ORIGIN;


    @Nullable
    @Contract(value="_, _, false -> !null")
    public Vec3 getPoint(@Nullable Entity entity, @NotNull Level level, boolean allowNull) {
        switch (this) {
            case PLAYER_SPAWN: 
            case PLAYER_NATURAL_SPAWN: {
                if (entity instanceof Player) {
                    DistanceFromCoordinatesConditionRegistry.warnOnce("Used reference '" + this.name().toLowerCase(Locale.ROOT) + "' which is not implemented yet, defaulting to world spawn.");
                }
                if (entity == null) {
                    DistanceFromCoordinatesConditionRegistry.warnOnce("Used entity-condition-only reference point in block condition, defaulting to world spawn.");
                }
            }
            case WORLD_SPAWN: {
                if (allowNull && level.m_46472_() != Level.f_46428_) {
                    return null;
                }
                LevelData data = level.m_6106_();
                BlockPos spawnPos = new BlockPos(data.m_6789_(), data.m_6527_(), data.m_6526_());
                if (!level.m_6857_().m_61937_(spawnPos)) {
                    spawnPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos((int)level.m_6857_().m_6347_(), 0, (int)level.m_6857_().m_6345_()));
                }
                return new Vec3((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
            }
        }
        return Vec3.f_82478_;
    }
}

