/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common;

import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.util.ApoliConfigs;
import io.github.apace100.apoli.util.StackPowerUtil;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.VariableAccess;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.component.IPowerDataCache;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.configuration.power.InteractionPowerConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.ApoliCommon;
import io.github.edwinmindcraft.apoli.common.network.S2CActiveSpawnPowerPacket;
import io.github.edwinmindcraft.apoli.common.power.ActionOnBeingUsedPower;
import io.github.edwinmindcraft.apoli.common.power.ActionOnBlockBreakPower;
import io.github.edwinmindcraft.apoli.common.power.ActionOnBlockUsePower;
import io.github.edwinmindcraft.apoli.common.power.ActionOnEntityUsePower;
import io.github.edwinmindcraft.apoli.common.power.ActionOnItemUsePower;
import io.github.edwinmindcraft.apoli.common.power.ActionOnLandPower;
import io.github.edwinmindcraft.apoli.common.power.ActionOnWakeUpPower;
import io.github.edwinmindcraft.apoli.common.power.AttackerActionWhenHitPower;
import io.github.edwinmindcraft.apoli.common.power.CombatHitActionPower;
import io.github.edwinmindcraft.apoli.common.power.EffectImmunityPower;
import io.github.edwinmindcraft.apoli.common.power.InventoryPower;
import io.github.edwinmindcraft.apoli.common.power.InvulnerablePower;
import io.github.edwinmindcraft.apoli.common.power.KeepInventoryPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyDamageDealtPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyDamageTakenPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyFallingPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyJumpPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyPlayerSpawnPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyValueBlockPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyValuePower;
import io.github.edwinmindcraft.apoli.common.power.PreventBlockActionPower;
import io.github.edwinmindcraft.apoli.common.power.PreventDeathPower;
import io.github.edwinmindcraft.apoli.common.power.PreventGameEventPower;
import io.github.edwinmindcraft.apoli.common.power.PreventItemActionPower;
import io.github.edwinmindcraft.apoli.common.power.PreventSleepPower;
import io.github.edwinmindcraft.apoli.common.power.RestrictArmorPower;
import io.github.edwinmindcraft.apoli.common.power.SelfActionWhenHitPower;
import io.github.edwinmindcraft.apoli.common.power.SelfCombatActionPower;
import io.github.edwinmindcraft.apoli.common.power.TargetCombatActionPower;
import io.github.edwinmindcraft.apoli.common.power.TooltipPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ActionOnItemUseConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyFallingConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyValueBlockConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.apoli.common.util.LivingDamageCache;
import io.github.edwinmindcraft.apoli.common.util.ModifyPlayerSpawnCache;
import io.github.edwinmindcraft.apoli.common.util.SpawnLookupScheduler;
import io.github.edwinmindcraft.calio.api.event.CalioDynamicRegistryEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.VanillaGameEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="apoli")
public class ApoliPowerEventHandler {
    @SubscribeEvent
    public static void modifyBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        Level world = player.m_20193_();
        BlockState state = event.getState();
        Optional position = event.getPosition();
        if (position.isEmpty()) {
            return;
        }
        float hardness = state.m_60800_((BlockGetter)world, (BlockPos)position.get());
        if (hardness <= 0.0f) {
            return;
        }
        float speed = event.getNewSpeed();
        boolean stateCheck = state.canHarvestBlock((BlockGetter)event.getEntity().m_9236_(), (BlockPos)position.get(), event.getEntity());
        boolean forgeCheck = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)event.getEntity());
        int toolFactor = forgeCheck ? 30 : 100;
        float factor = hardness * (float)toolFactor;
        speed = IPowerContainer.modify((Entity)player, (ModifyValueBlockPower)ApoliPowers.MODIFY_BREAK_SPEED.get(), speed / factor, p -> ConfiguredBlockCondition.check(((ModifyValueBlockConfiguration)((ConfiguredPower)p.m_203334_()).getConfiguration()).condition(), (LevelReader)world, (BlockPos)position.get(), (NonNullSupplier<BlockState>)((NonNullSupplier)() -> state))) * factor;
        if (stateCheck == forgeCheck) {
            event.setNewSpeed(speed);
        } else if (stateCheck) {
            event.setNewSpeed(speed * 3.3333333f);
        } else {
            event.setNewSpeed(speed * 0.3f);
        }
        if (speed <= 0.0f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onSleep(PlayerSleepInBedEvent event) {
        if (PreventSleepPower.tryPreventSleep(event.getEntity(), event.getEntity().m_20193_(), event.getPos())) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
    }

    @SubscribeEvent
    public static void onWakeUp(PlayerWakeUpEvent event) {
        if (!event.wakeImmediately() && !event.updateLevel()) {
            event.getEntity().m_21257_().ifPresent(pos -> ActionOnWakeUpPower.execute((Entity)event.getEntity(), pos));
        }
    }

    @SubscribeEvent
    public static void stopUsing(LivingEntityUseItemEvent.Stop event) {
        ActionOnItemUsePower.execute((Entity)event.getEntity(), event.getItem(), VariableAccess.hand(event.getEntity(), event.getEntity().m_7655_()), ActionOnItemUseConfiguration.TriggerType.STOP, ActionOnItemUseConfiguration.PriorityPhase.AFTER);
    }

    @SubscribeEvent
    public static void onTossItem(ItemTossEvent event) {
        ActionOnItemUsePower.execute((Entity)event.getPlayer(), event.getEntity().m_32055_(), new VariableAccess<ItemStack>(() -> ((ItemEntity)event.getEntity()).m_32055_(), arg_0 -> ((ItemEntity)event.getEntity()).m_32045_(arg_0)), ActionOnItemUseConfiguration.TriggerType.STOP, ActionOnItemUseConfiguration.PriorityPhase.ALL);
    }

    @SubscribeEvent
    public static void tickUsing(LivingEntityUseItemEvent.Tick event) {
        ActionOnItemUsePower.execute((Entity)event.getEntity(), event.getItem(), VariableAccess.hand(event.getEntity(), event.getEntity().m_7655_()), ActionOnItemUseConfiguration.TriggerType.DURING, ActionOnItemUseConfiguration.PriorityPhase.AFTER);
    }

    @SubscribeEvent
    public static void finishUsing(LivingEntityUseItemEvent.Finish event) {
        ActionOnItemUsePower.execute((Entity)event.getEntity(), event.getItem(), new VariableAccess<ItemStack>(() -> ((LivingEntityUseItemEvent.Finish)event).getResultStack(), arg_0 -> ((LivingEntityUseItemEvent.Finish)event).setResultStack(arg_0)), ActionOnItemUseConfiguration.TriggerType.FINISH, ActionOnItemUseConfiguration.PriorityPhase.AFTER);
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            ActionOnBlockBreakPower.execute((Entity)event.getPlayer(), (LevelReader)event.getLevel(), event.getPos(), (NonNullSupplier<BlockState>)((NonNullSupplier)() -> ((BlockEvent.BreakEvent)event).getState()), !event.isCanceled());
        }
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        LivingEntity entityLiving = event.getEntity();
        ActionOnLandPower.execute((Entity)entityLiving);
        if (IPowerContainer.getPowers((Entity)entityLiving, (ModifyFallingPower)ApoliPowers.MODIFY_FALLING.get()).stream().anyMatch(x -> !((ModifyFallingConfiguration)((ConfiguredPower)x.m_203334_()).getConfiguration()).takeFallDamage())) {
            event.setDamageMultiplier(0.0f);
        }
    }

    private static float computeDamageAmount(Entity target, DamageSource source, float amount, boolean exec) {
        LivingDamageCache pdc;
        Consumer selfConsumer;
        Entity sourceEntity = source.m_7639_();
        if (sourceEntity != null) {
            LivingDamageCache pdc2;
            ModifyDamageDealtPower factory;
            Consumer otherConsumer = exec ? x -> ((ModifyDamageDealtPower)((ConfiguredPower)x.m_203334_()).getFactory()).execute((ConfiguredPower)x.m_203334_(), sourceEntity, target) : x -> {};
            ModifyDamageDealtPower modifyDamageDealtPower = factory = source.m_269533_(DamageTypeTags.f_268524_) ? (ModifyDamageDealtPower)ApoliPowers.MODIFY_PROJECTILE_DAMAGE.get() : (ModifyDamageDealtPower)ApoliPowers.MODIFY_DAMAGE_DEALT.get();
            if (target instanceof LivingDamageCache && (pdc2 = (LivingDamageCache)target).getModifyDamageDealtPowers() != null) {
                amount = (float)IPowerContainer.modify(sourceEntity, factory, pdc2.getModifyDamageDealtPowers(), amount, otherConsumer);
            } else {
                float finalAmount = amount;
                amount = IPowerContainer.modify(sourceEntity, factory, amount, x -> factory.check((ConfiguredPower)x.m_203334_(), sourceEntity, target, source, finalAmount), otherConsumer);
            }
        }
        Consumer<Object> consumer = selfConsumer = exec ? x -> ((ModifyDamageTakenPower)((ConfiguredPower)x.m_203334_()).getFactory()).execute((ConfiguredPower)x.m_203334_(), target, source) : x -> {};
        if (target instanceof LivingDamageCache && (pdc = (LivingDamageCache)target).getModifyDamageTakenPowers() != null) {
            amount = (float)IPowerContainer.modify(sourceEntity, (ModifyDamageTakenPower)ApoliPowers.MODIFY_DAMAGE_TAKEN.get(), pdc.getModifyDamageTakenPowers(), amount, selfConsumer);
            if (amount > 0.0f) {
                pdc.bypassDamageCheck(true);
            }
        } else {
            float finalAmount = amount;
            amount = IPowerContainer.modify(sourceEntity, (ModifyDamageTakenPower)ApoliPowers.MODIFY_DAMAGE_TAKEN.get(), amount, x -> ((ModifyDamageTakenPower)((ConfiguredPower)x.m_203334_()).getFactory()).check((ConfiguredPower)x.m_203334_(), target, source, finalAmount), selfConsumer);
        }
        return amount;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void livingDamage(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        event.setAmount(ApoliPowerEventHandler.computeDamageAmount((Entity)target, source, amount, false));
        if (event.getAmount() != amount && event.getAmount() <= 0.0f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void livingAttack(LivingAttackEvent event) {
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        if (target instanceof LivingDamageCache) {
            LivingDamageCache ldc = (LivingDamageCache)target;
            ldc.gatherDamagePowers((Entity)target, source, amount);
        }
        IPowerDataCache.get(target).ifPresent(x -> x.setDamage(amount));
        float newAmount = ApoliPowerEventHandler.computeDamageAmount((Entity)target, source, amount, true);
        if (newAmount != amount && newAmount <= 0.0f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void livingJump(LivingEvent.LivingJumpEvent event) {
        double modified = ModifyJumpPower.apply((Entity)event.getEntity(), event.getEntity().m_20184_().f_82480_);
        ApoliPowerEventHandler.updateJumpHeight(modified, event.getEntity());
    }

    private static void updateJumpHeight(double height, LivingEntity entity) {
        Vec3 vel = entity.m_20184_();
        double delta = height - vel.f_82480_;
        if (delta == 0.0) {
            return;
        }
        entity.m_20256_(vel.m_82520_(0.0, delta, 0.0));
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        float amount = event.getAmount();
        LazyOptional<IPowerDataCache> pdc = IPowerDataCache.get(target);
        boolean validate = event.getAmount() != target.f_20898_;
        float prevDamage = pdc.map(IPowerDataCache::getDamage).orElse(Float.valueOf(Float.POSITIVE_INFINITY)).floatValue();
        pdc.ifPresent(x -> x.setDamage(amount));
        if (amount > 0.0f && pdc.map(IPowerDataCache::shouldExecuteActions).orElse(true).booleanValue()) {
            boolean canRunAgain = !event.isCanceled() && !validate && (float)target.f_19802_ > 10.0f && !event.getSource().m_269533_(DamageTypeTags.f_273918_) && prevDamage <= amount;
            pdc.ifPresent(cache -> cache.setShouldExecuteActions(canRunAgain));
            SelfActionWhenHitPower.execute((Entity)target, source, amount);
            AttackerActionWhenHitPower.execute((Entity)target, source, amount);
            if (attacker != null) {
                SelfCombatActionPower.onHit(attacker, (Entity)target, source, amount);
                TargetCombatActionPower.onHit(attacker, (Entity)target, source, amount);
                CombatHitActionPower.perform(attacker, (Entity)target, source, amount);
            }
        } else {
            pdc.ifPresent(cache -> cache.setShouldExecuteActions(true));
        }
    }

    @SubscribeEvent
    public static void onLivingKilled(LivingDeathEvent event) {
        ServerPlayer serverPlayer;
        IPowerDataCache.get(event.getEntity()).map(IPowerDataCache::getDamage).ifPresent(x -> {
            Entity patt12958$temp = event.getSource().m_7639_();
            if (patt12958$temp instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt12958$temp;
                SelfCombatActionPower.onKill((Entity)living, (Entity)event.getEntity(), event.getSource(), x.floatValue());
            }
        });
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && ((ModifyPlayerSpawnCache)(serverPlayer = (ServerPlayer)livingEntity)).getActiveSpawnPower() != null) {
            ApoliCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new S2CActiveSpawnPowerPacket(Optional.of(((ModifyPlayerSpawnCache)serverPlayer).getActiveSpawnPower())));
        }
    }

    @SubscribeEvent
    public static void updateHealAmount(LivingHealEvent event) {
        event.setAmount(IPowerContainer.modify((Entity)event.getEntity(), (ModifyValuePower)ApoliPowers.MODIFY_HEALING.get(), event.getAmount()));
    }

    @SubscribeEvent
    public static void playerTick(LivingEvent.LivingTickEvent event) {
        ServerPlayer spe;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && ApoliAPI.getPowerContainer((Entity)(spe = (ServerPlayer)livingEntity)) != null && ApoliAPI.getPowerContainer((Entity)spe).hasPower((PowerFactory)ApoliPowers.MODIFY_PLAYER_SPAWN.get())) {
            ((ModifyPlayerSpawnPower)ApoliPowers.MODIFY_PLAYER_SPAWN.get()).tick((Entity)spe);
        }
    }

    @SubscribeEvent
    public static void onCalioReload(CalioDynamicRegistryEvent.Reload event) throws InterruptedException {
        SpawnLookupScheduler.INSTANCE.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            ServerPlayer serverPlayer;
            Player player = (Player)livingEntity;
            LivingEntity livingEntity2 = event.getEntity();
            if (livingEntity2 instanceof ServerPlayer && IPowerContainer.hasPower((Entity)(serverPlayer = (ServerPlayer)livingEntity2), (ModifyPlayerSpawnPower)ApoliPowers.MODIFY_PLAYER_SPAWN.get())) {
                ((ModifyPlayerSpawnPower)ApoliPowers.MODIFY_PLAYER_SPAWN.get()).checkSpawn(serverPlayer);
            }
            if (!player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
                IPowerContainer.getPowers((Entity)player, (InventoryPower)ApoliPowers.INVENTORY.get()).stream().map(Holder::m_203334_).forEach(inventory -> InventoryPower.tryDropItemsOnDeath(inventory, player));
                IPowerContainer.getPowers((Entity)player, (KeepInventoryPower)ApoliPowers.KEEP_INVENTORY.get()).forEach(power -> ((KeepInventoryPower)((ConfiguredPower)power.m_203334_()).getFactory()).captureItems((ConfiguredPower)power.m_203334_(), player));
            }
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        int flags;
        List tooltips = event.getToolTip();
        int n = flags = event.getItemStack().m_41782_() && Objects.requireNonNull(event.getItemStack().m_41783_()).m_128425_("HideFlags", 99) ? event.getItemStack().m_41783_().m_128451_("HideFlags") : event.getItemStack().m_41720_().getDefaultTooltipHideFlags(event.getItemStack());
        if (((Boolean)ApoliConfigs.CLIENT.tooltips.showUsabilityHints.get()).booleanValue() && (flags & ItemStack.TooltipPart.ADDITIONAL.m_41809_()) == 0) {
            ArrayList powers = new ArrayList(PreventItemActionPower.getPreventingForDisplay((Entity)event.getEntity(), event.getItemStack()));
            int size = powers.size();
            if (!powers.isEmpty()) {
                powers.removeIf(x -> x.getData().hidden());
                String key = "tooltip.apoli.unusable." + event.getItemStack().m_41780_().name().toLowerCase(Locale.ROOT);
                ChatFormatting textColor = ChatFormatting.GRAY;
                ChatFormatting powerColor = ChatFormatting.RED;
                if (((Boolean)ApoliConfigs.CLIENT.tooltips.compactUsabilityHints.get()).booleanValue() || powers.size() == 0) {
                    if (powers.size() == 1) {
                        ConfiguredPower power = (ConfiguredPower)powers.get(0);
                        tooltips.add(Component.m_237110_((String)(key + ".single"), (Object[])new Object[]{power.getData().getName().m_130940_(powerColor)}).m_130940_(textColor));
                    } else {
                        tooltips.add(Component.m_237110_((String)(key + ".multiple"), (Object[])new Object[]{Component.m_237113_((String)("" + (powers.size() == 0 ? size : powers.size()))).m_130940_(powerColor)}).m_130940_(textColor));
                    }
                } else {
                    MutableComponent powerNameList = ((ConfiguredPower)powers.get(0)).getData().getName().m_130940_(powerColor);
                    for (int i = 1; i < powers.size(); ++i) {
                        powerNameList = powerNameList.m_7220_((Component)Component.m_237113_((String)", ").m_130940_(textColor));
                        powerNameList = powerNameList.m_7220_((Component)((ConfiguredPower)powers.get(i)).getData().getName().m_130940_(powerColor));
                    }
                    MutableComponent preventText = Component.m_237110_((String)(key + ".single"), (Object[])new Object[]{powerNameList}).m_130940_(textColor);
                    tooltips.add(preventText);
                }
            }
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            List<StackPowerUtil.StackPower> powers = StackPowerUtil.getPowers(event.getItemStack(), slot).stream().filter(sp -> !sp.isHidden).toList();
            if (powers.size() <= 0) continue;
            tooltips.add(Component.m_237119_());
            tooltips.add(Component.m_237115_((String)("item.modifiers." + slot.m_20751_())).m_130940_(ChatFormatting.GRAY));
            powers.forEach(sp -> {
                if (PowerTypeRegistry.contains(sp.powerId)) {
                    PowerType<?> powerType = PowerTypeRegistry.get(sp.powerId);
                    tooltips.add(Component.m_237113_((String)" ").m_7220_(powerType.getName()).m_130940_(sp.isNegative ? ChatFormatting.RED : ChatFormatting.BLUE));
                    if (event.getFlags().m_7050_()) {
                        tooltips.add(Component.m_237113_((String)"  ").m_7220_(powerType.getDescription()).m_130940_(ChatFormatting.GRAY));
                    }
                }
            });
        }
        TooltipPower.tryAdd((Entity)event.getEntity(), event.getItemStack(), event.getToolTip());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void playerEntityInteraction(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if (player.m_5833_()) {
            return;
        }
        Entity target = event.getTarget();
        Optional<InteractionResult> result = Stream.concat(ActionOnEntityUsePower.tryInteract((Entity)player, target, event.getHand()).stream(), ActionOnBeingUsedPower.tryInteract(target, (Entity)player, event.getHand()).stream()).reduce(InteractionPowerConfiguration::reduce);
        result.ifPresent(res -> {
            if (res != InteractionResult.PASS) {
                event.setCancellationResult(res);
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void playerBlockInteraction(PlayerInteractEvent.RightClickBlock event) {
        ActionOnBlockUsePower.tryInteract((Entity)event.getEntity(), event.getPos(), event.getFace(), event.getHand()).ifPresent(res -> {
            if (res.m_19077_()) {
                event.setCancellationResult(res);
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void preventPotionEffect(MobEffectEvent.Applicable event) {
        if (EffectImmunityPower.isImmune((Entity)event.getEntity(), event.getEffectInstance())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void preventGameEvent(VanillaGameEvent event) {
        if (event.getCause() != null && PreventGameEventPower.tryPreventGameEvent(event.getCause(), event.getVanillaEvent())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void makeInvulnerable(LivingAttackEvent event) {
        LivingEntity entityLiving = event.getEntity();
        if (InvulnerablePower.isInvulnerableTo((Entity)entityLiving, event.getSource())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void preventLivingDeath(LivingDeathEvent event) {
        IPowerDataCache.get(event.getEntity()).map(IPowerDataCache::getDamage).ifPresent(x -> {
            if (PreventDeathPower.tryPreventDeath((Entity)event.getEntity(), event.getSource(), x.floatValue())) {
                event.getEntity().m_21153_(1.0f);
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void preventEntityInteraction(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if (player.m_5833_()) {
            return;
        }
        Entity target = event.getTarget();
        Optional<InteractionResult> result = ActionOnEntityUsePower.tryPrevent((Entity)player, target, event.getHand());
        if (result.isEmpty() || result.get() == InteractionResult.PASS) {
            result = ActionOnBeingUsedPower.tryPrevent(target, (Entity)player, event.getHand());
        }
        result.ifPresent(res -> {
            if (res != InteractionResult.PASS) {
                event.setCancellationResult(res);
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void preventBlockInteraction(PlayerInteractEvent.RightClickBlock event) {
        if (PreventBlockActionPower.isUsagePrevented((Entity)event.getEntity(), event.getPos())) {
            event.setUseBlock(Event.Result.DENY);
        }
        if (!(event.getItemStack().m_41720_() instanceof BlockItem) && PreventItemActionPower.isUsagePrevented((Entity)event.getEntity(), event.getItemStack())) {
            event.setUseItem(Event.Result.DENY);
        }
        if (event.getItemStack().m_41720_() instanceof ArmorItem) {
            EquipmentSlot slot = Mob.m_147233_((ItemStack)event.getItemStack());
            if (RestrictArmorPower.isForbidden((Entity)event.getEntity(), slot, event.getItemStack())) {
                event.setUseItem(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void preventItemUsage(PlayerInteractEvent.RightClickItem event) {
        if (PreventItemActionPower.isUsagePrevented((Entity)event.getEntity(), event.getItemStack())) {
            event.setCanceled(true);
        }
        if (event.getItemStack().m_41720_() instanceof ArmorItem) {
            EquipmentSlot slot = Mob.m_147233_((ItemStack)event.getItemStack());
            if (RestrictArmorPower.isForbidden((Entity)event.getEntity(), slot, event.getItemStack())) {
                event.setCanceled(true);
            }
        }
    }
}

