/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common;

import com.mojang.brigadier.CommandDispatcher;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.EntityLinkedItemStack;
import io.github.apace100.apoli.command.PowerCommand;
import io.github.apace100.apoli.command.ResourceCommand;
import io.github.apace100.apoli.util.InventoryUtil;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.component.IPowerDataCache;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.apoli.common.ApoliCommon;
import io.github.edwinmindcraft.apoli.common.component.EntityLinkedItemStackImpl;
import io.github.edwinmindcraft.apoli.common.component.PowerContainer;
import io.github.edwinmindcraft.apoli.common.component.PowerDataCache;
import io.github.edwinmindcraft.apoli.common.network.S2CCachedSpawnsPacket;
import io.github.edwinmindcraft.apoli.common.network.S2CSynchronizePowerContainer;
import io.github.edwinmindcraft.apoli.common.power.KeepInventoryPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyPlayerSpawnPower;
import io.github.edwinmindcraft.apoli.common.registry.ApoliCapabilities;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.apoli.common.util.ModifyPlayerSpawnCache;
import io.github.edwinmindcraft.apoli.common.util.SpawnLookupUtil;
import io.github.edwinmindcraft.calio.api.event.CalioDynamicRegistryEvent;
import io.github.edwinmindcraft.calio.api.event.DynamicRegistrationEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.MappedRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="apoli")
public class ApoliEventHandler {
    private static final Set<ResourceLocation> DISABLED_POWERS = new HashSet<ResourceLocation>();

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)object;
            event.addCapability(IPowerContainer.KEY, (ICapabilityProvider)new PowerContainer(living));
            event.addCapability(IPowerDataCache.KEY, (ICapabilityProvider)new PowerDataCache());
        }
    }

    @SubscribeEvent
    public static void attachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        event.addCapability(EntityLinkedItemStack.KEY, (ICapabilityProvider)new EntityLinkedItemStackImpl((ItemStack)event.getObject()));
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer spe = (ServerPlayer)player;
            ApoliCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> spe), (Object)new S2CCachedSpawnsPacket(SpawnLookupUtil.getPowersWithSpawns()));
            S2CSynchronizePowerContainer packet = S2CSynchronizePowerContainer.forEntity((Entity)spe);
            if (packet == null) {
                Apoli.LOGGER.error("Couldn't create synchronization packet for player {}", (Object)spe.m_6302_());
            }
            ApoliCommon.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
        }
    }

    @SubscribeEvent
    public static void calioLoadComplete(CalioDynamicRegistryEvent.LoadComplete event) {
        MappedRegistry configuredPowers = event.getRegistryManager().get(ApoliDynamicRegistries.CONFIGURED_POWER_KEY);
        configuredPowers.m_203611_().forEach(holder -> {
            if (!holder.m_203633_()) {
                Apoli.LOGGER.info("Missing power: {}", (Object)holder.m_205785_());
            } else {
                List<String> warnings = ((ConfiguredPower)holder.m_203334_()).getWarnings(event.getRegistryManager());
                List<String> errors = ((ConfiguredPower)holder.m_203334_()).getErrors(event.getRegistryManager());
                if (errors.isEmpty() && warnings.isEmpty()) {
                    return;
                }
                Apoli.LOGGER.info("Status report for power: {}", (Object)holder.m_205785_());
                warnings.forEach(arg_0 -> ((Logger)Apoli.LOGGER).warn(arg_0));
                errors.forEach(arg_0 -> ((Logger)Apoli.LOGGER).error(arg_0));
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPowerLoad(DynamicRegistrationEvent<ConfiguredPower<?, ?>> event) {
        if (((ConfiguredPower)event.getOriginal()).getData().forgeCondition().isPresent() && !((ConfiguredPower)event.getOriginal()).getData().forgeCondition().get().test(ICondition.IContext.EMPTY)) {
            ApoliEventHandler.disablePower(event.getRegistryName());
            event.setCanceled(true);
        }
    }

    private static void disablePower(ResourceLocation powerId) {
        DISABLED_POWERS.add(powerId);
    }

    public static boolean isPowerDisabled(ResourceLocation powerId) {
        return DISABLED_POWERS.contains(powerId);
    }

    @SubscribeEvent
    public static void onDataSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                IPowerContainer.get((Entity)player).ifPresent(IPowerContainer::rebuildCache);
                IPowerContainer.sync((Entity)player);
            }
        }
    }

    @SubscribeEvent
    public static void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        IPowerContainer.get((Entity)event.getEntity()).ifPresent(x -> x.getPowers().forEach(y -> ((ConfiguredPower)y.m_203334_()).onRemoved((Entity)event.getEntity())));
    }

    @SubscribeEvent
    public static void livingTick(LivingEvent.LivingTickEvent event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            IPowerContainer.get((Entity)event.getEntity()).ifPresent(IPowerContainer::serverTick);
        }
        InventoryUtil.forEachStack((Entity)event.getEntity(), slot -> {
            if (slot.m_142196_().m_41619_() || slot.m_142196_().getCapability(ApoliCapabilities.ENTITY_LINKED_ITEM_STACK).map(eli -> eli.getEntity() == event.getEntity()).orElse(false).booleanValue()) {
                return;
            }
            slot.m_142196_().getCapability(ApoliCapabilities.ENTITY_LINKED_ITEM_STACK).ifPresent(eli -> eli.setEntity((Entity)event.getEntity()));
        });
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        LazyOptional<IPowerContainer> original = IPowerContainer.get((Entity)event.getOriginal());
        LazyOptional<IPowerContainer> player = IPowerContainer.get((Entity)event.getEntity());
        if (original.isPresent() != player.isPresent()) {
            Apoli.LOGGER.info("Capability mismatch: original:{}, new:{}", (Object)original.isPresent(), (Object)player.isPresent());
        }
        original.ifPresent(x -> x.getPowers().forEach(y -> ((ConfiguredPower)y.m_203334_()).onRemoved((Entity)event.getOriginal())));
        player.ifPresent(p -> original.ifPresent(o -> p.readFromNbt(o.writeToNbt(new CompoundTag()))));
        if (!event.getEntity().m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
            IPowerContainer.getPowers((Entity)event.getEntity(), (KeepInventoryPower)ApoliPowers.KEEP_INVENTORY.get()).forEach(power -> ((KeepInventoryPower)((ConfiguredPower)power.m_203334_()).getFactory()).restoreItems((ConfiguredPower)power.m_203334_(), event.getEntity()));
        }
        if (event.getEntity() instanceof ServerPlayer) {
            ((ModifyPlayerSpawnCache)event.getEntity()).setActiveSpawnPower(((ModifyPlayerSpawnCache)event.getOriginal()).getActiveSpawnPower());
        }
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            IPowerContainer.sync((Entity)sp);
            if (!event.isEndConquered()) {
                ((ModifyPlayerSpawnPower)ApoliPowers.MODIFY_PLAYER_SPAWN.get()).schedulePlayerToSpawn(sp);
                IPowerContainer.get((Entity)sp).ifPresent(x -> x.getPowers().forEach(y -> ((ConfiguredPower)y.m_203334_()).onRespawn((Entity)sp)));
            }
        }
    }

    @SubscribeEvent
    public static void playerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            IPowerContainer.sync((Entity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void trackNew(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            IPowerContainer.sync((Entity)le);
        }
    }

    @SubscribeEvent
    public static void trackEntity(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer se = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)player;
                IPowerContainer.sync((Entity)target, se);
            }
        }
    }

    @SubscribeEvent
    public static void initializeCommands(RegisterCommandsEvent event) {
        PowerCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ResourceCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

