/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.power.OverlayPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ColorConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.OverlayConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class ApoliPowerOverlay
implements IGuiOverlay {
    private final Predicate<OverlayConfiguration> shouldDraw;

    public ApoliPowerOverlay(Predicate<OverlayConfiguration> shouldDraw) {
        this.shouldDraw = shouldDraw;
    }

    private void renderPower(ConfiguredPower<OverlayConfiguration, ?> power, GuiGraphics graphics, int width, int height, float partialTick) {
        double x;
        double overlayHeight;
        double overlayWidth;
        OverlayConfiguration configuration = power.getConfiguration();
        ColorConfiguration color = configuration.color();
        double y = switch (configuration.mode()) {
            case OverlayConfiguration.DrawMode.NAUSEA -> {
                color = color.multiply(configuration.strength()).withAlpha(1.0f);
                double d = Mth.m_14139_((double)configuration.strength(), (double)2.0, (double)1.0);
                overlayWidth = (double)width * d;
                overlayHeight = (double)height * d;
                x = ((double)width - overlayWidth) / 2.0;
                yield ((double)height - overlayHeight) / 2.0;
            }
            default -> {
                color = color.withAlpha(configuration.strength());
                overlayWidth = width;
                overlayHeight = height;
                x = 0.0;
                yield 0.0;
            }
        };
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        switch (configuration.mode()) {
            case NAUSEA: {
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                break;
            }
            default: {
                RenderSystem.defaultBlendFunc();
            }
        }
        RenderSystem.setShaderColor((float)color.red(), (float)color.green(), (float)color.blue(), (float)color.alpha());
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)configuration.texture());
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_5483_(x, y + overlayHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(x + overlayWidth, y + overlayHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(x + overlayWidth, y, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_5483_(x, y, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        boolean hideGui = Minecraft.m_91087_().f_91066_.f_92062_;
        boolean isFirstPerson = Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
        List<ConfiguredPower> powers = IPowerContainer.getPowers(Minecraft.m_91087_().m_91288_(), (OverlayPower)ApoliPowers.OVERLAY.get()).stream().map(Holder::m_203334_).filter(x -> !(!this.shouldDraw.test((OverlayConfiguration)x.getConfiguration()) || ((OverlayConfiguration)x.getConfiguration()).hideWithHud() && hideGui || !((OverlayConfiguration)x.getConfiguration()).visibleInThirdPerson() && !isFirstPerson)).toList();
        for (ConfiguredPower power : powers) {
            this.renderPower(power, graphics, width, height, partialTick);
        }
    }
}

