/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.ApoliClient;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.Calio;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.ApoliCommon;
import io.github.edwinmindcraft.apoli.common.network.C2SFetchActiveSpawnPowerPacket;
import io.github.edwinmindcraft.apoli.common.power.ParticlePower;
import io.github.edwinmindcraft.apoli.common.power.PhasingPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.PhasingConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.apoli.common.util.SpawnLookupUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="apoli", value={Dist.CLIENT})
public class ApoliClientEventHandler {
    private static final HashMap<String, KeyMapping> idToKeyBindingMap = new HashMap();
    private static final HashMap<String, Boolean> lastKeyBindingStates = new HashMap();
    private static boolean initializedKeyBindingMap = false;

    public static void registerPowerKeybinding(String keyId, KeyMapping keyBinding) {
        idToKeyBindingMap.put(keyId, keyBinding);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockOverlay(RenderBlockScreenEffectEvent event) {
        if (IPowerContainer.hasPower((Entity)event.getPlayer(), (PhasingPower)ApoliPowers.PHASING.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onInitScreen(ScreenEvent.Init event) {
        if (event.getScreen() instanceof DeathScreen && Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.reviveCaps();
            if (ApoliAPI.getPowerContainer((Entity)Minecraft.m_91087_().f_91074_).hasPower((PowerFactory)ApoliPowers.MODIFY_PLAYER_SPAWN.get())) {
                ApoliCommon.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SFetchActiveSpawnPowerPacket());
            }
            Minecraft.m_91087_().f_91074_.invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        SpawnLookupUtil.resetSpawnCache();
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            boolean firstPerson = Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
            ParticlePower.renderParticles((Entity)event.getEntity(), (Entity)player, firstPerson);
        }
    }

    private static KeyMapping getKeyBinding(String key) {
        if (!idToKeyBindingMap.containsKey(key)) {
            if (!initializedKeyBindingMap) {
                initializedKeyBindingMap = true;
                Minecraft client = Minecraft.m_91087_();
                for (int i = 0; i < client.f_91066_.f_92059_.length; ++i) {
                    idToKeyBindingMap.put(client.f_91066_.f_92059_[i].m_90860_(), client.f_91066_.f_92059_[i]);
                }
                return ApoliClientEventHandler.getKeyBinding(key);
            }
            return null;
        }
        return idToKeyBindingMap.get(key);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            LocalPlayer player;
            Minecraft instance = Minecraft.m_91087_();
            if (ApoliClient.shouldReapplyShaders) {
                ApoliClient.shouldReapplyShaders = false;
                instance.f_91063_.m_109106_(instance.f_91066_.m_92176_().m_90612_() ? instance.m_91288_() : null);
            }
            if ((player = instance.f_91074_) != null) {
                IPowerContainer.get((Entity)player).ifPresent(container -> {
                    HashMap currentKeyBindingStates = new HashMap();
                    HashSet<ResourceLocation> pressedPowers = new HashSet<ResourceLocation>();
                    MappedRegistry<ConfiguredPower<?, ?>> powers = ApoliAPI.getPowers();
                    for (Holder<ConfiguredPower<?, ?>> holder : container.getPowers()) {
                        if (!holder.m_203633_()) continue;
                        ((ConfiguredPower)holder.m_203334_()).getKey((Entity)player).ifPresent(key -> {
                            KeyMapping binding = ApoliClientEventHandler.getKeyBinding(key.key());
                            if (binding != null) {
                                ResourceLocation keyValue;
                                if (!currentKeyBindingStates.containsKey(key.key())) {
                                    currentKeyBindingStates.put(key.key(), binding.m_90857_());
                                }
                                if (((Boolean)currentKeyBindingStates.get(key.key())).booleanValue() && (key.continuous() || !lastKeyBindingStates.getOrDefault(key.key(), false).booleanValue()) && (keyValue = powers.m_7981_((Object)((ConfiguredPower)holder.m_203334_()))) != null) {
                                    pressedPowers.add(keyValue);
                                }
                            } else if (Calio.isDebugMode()) {
                                Apoli.LOGGER.warn("No such key: {}", (Object)key.key());
                            }
                        });
                    }
                    lastKeyBindingStates.clear();
                    lastKeyBindingStates.putAll(currentKeyBindingStates);
                    if (pressedPowers.size() > 0) {
                        ApoliAPI.performPowers(pressedPowers);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void renderFog(ViewportEvent.RenderFog event) {
        LivingEntity living;
        Optional<Float> renderMethod;
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof LivingEntity && (renderMethod = PhasingPower.getRenderMethod((Entity)(living = (LivingEntity)entity), PhasingConfiguration.RenderType.BLINDNESS)).isPresent() && MiscUtil.getInWallBlockState(living) != null) {
            float v;
            float s;
            float view = renderMethod.get().floatValue();
            if (event.getMode() == FogRenderer.FogMode.FOG_SKY) {
                s = 0.0f;
                v = view * 0.8f;
            } else {
                s = view * 0.25f;
                v = view;
            }
            RenderSystem.setShaderFogStart((float)s);
            RenderSystem.setShaderFogEnd((float)v);
        }
    }

    @SubscribeEvent
    public static void fogColor(ViewportEvent.ComputeFogColor event) {
        LivingEntity living;
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof LivingEntity && PhasingPower.hasRenderMethod((Entity)(living = (LivingEntity)entity), PhasingConfiguration.RenderType.BLINDNESS) && MiscUtil.getInWallBlockState(living) != null) {
            event.setBlue(0.0f);
            event.setGreen(0.0f);
            event.setRed(0.0f);
        }
    }
}

