/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.power.factory.power;

import com.mojang.serialization.Codec;
import io.github.apace100.apoli.util.HudRender;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.IHudRenderedPower;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.configuration.power.IHudRenderedVariableIntPowerConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.power.VariableIntPowerFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;

public abstract class HudRenderedVariableIntPowerFactory<T extends IHudRenderedVariableIntPowerConfiguration>
extends VariableIntPowerFactory<T>
implements IHudRenderedPower<T> {
    protected HudRenderedVariableIntPowerFactory(Codec<T> codec) {
        super(codec);
    }

    protected HudRenderedVariableIntPowerFactory(Codec<T> codec, boolean allowConditions) {
        super(codec, allowConditions);
    }

    @Override
    public HudRender getRenderSettings(ConfiguredPower<T, ?> configuration, Entity player) {
        return ((IHudRenderedVariableIntPowerConfiguration)configuration.getConfiguration()).hudRender();
    }

    @Override
    public float getFill(ConfiguredPower<T, ?> configuration, Entity player) {
        return this.getProgress(configuration, player);
    }

    @Override
    public boolean shouldRender(ConfiguredPower<T, ?> configuration, Entity player) {
        return true;
    }

    public static abstract class Simple<T extends IHudRenderedVariableIntPowerConfiguration>
    extends HudRenderedVariableIntPowerFactory<T> {
        protected Simple(Codec<T> codec) {
            super(codec);
        }

        protected Simple(Codec<T> codec, boolean allowConditions) {
            super(codec, allowConditions);
        }

        protected AtomicInteger getCurrentValue(ConfiguredPower<T, ?> configuration, IPowerContainer container) {
            return (AtomicInteger)configuration.getPowerData(container, () -> new AtomicInteger(((IHudRenderedVariableIntPowerConfiguration)configuration.getConfiguration()).initialValue()));
        }

        @Override
        protected int get(ConfiguredPower<T, ?> configuration, @Nullable IPowerContainer container) {
            if (container == null) {
                return ((IHudRenderedVariableIntPowerConfiguration)configuration.getConfiguration()).initialValue();
            }
            return this.getCurrentValue(configuration, container).get();
        }

        @Override
        protected void set(ConfiguredPower<T, ?> configuration, @Nullable IPowerContainer container, int value) {
            if (container == null) {
                return;
            }
            this.getCurrentValue(configuration, container).set(value);
        }

        @Override
        public void serialize(ConfiguredPower<T, ?> configuration, IPowerContainer container, CompoundTag tag) {
            tag.m_128405_("Value", this.get(configuration, container));
        }

        @Override
        public void deserialize(ConfiguredPower<T, ?> configuration, IPowerContainer container, CompoundTag tag) {
            this.set(configuration, container, tag.m_128451_("Value"));
        }
    }
}

