/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.power.factory;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.github.apace100.apoli.util.NamespaceAlias;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.IFactory;
import io.github.edwinmindcraft.apoli.api.power.ModifierData;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredModifier;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Holder;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class ModifierOperation {
    public static final Codec<ModifierOperation> STRICT_CODEC = ApoliRegistries.codec(() -> ApoliRegistries.MODIFIER_OPERATION.get());
    public static final Codec<ModifierOperation> CODEC = ModifierOperation.createCodec();
    private final Codec<ConfiguredModifier<?>> codec = IFactory.singleCodec(ModifierData.CODEC, data -> new ConfiguredModifier<ModifierOperation>(() -> this, (ModifierData)data), ConfiguredModifier::getData);
    private final Phase phase;
    private final int order;
    private final PropertyDispatch.TriFunction<List<Double>, Double, Double, Double> function;

    public ModifierOperation(Phase phase, int order, PropertyDispatch.TriFunction<List<Double>, Double, Double, Double> function) {
        this.phase = phase;
        this.order = order;
        this.function = function;
    }

    public Codec<ConfiguredModifier<?>> getCodec() {
        return this.codec;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public int getOrder() {
        return this.order;
    }

    public double apply(List<ConfiguredModifier<?>> instances, Entity entity, double base, double current) {
        return (Double)this.function.m_125475_(instances.stream().map(instance -> {
            double value = 0.0;
            if (instance.getData().resource().isPresent()) {
                LazyOptional<IPowerContainer> lazyOptional = IPowerContainer.get(entity);
                if (lazyOptional.isPresent() && lazyOptional.resolve().isPresent()) {
                    IPowerContainer container = (IPowerContainer)lazyOptional.resolve().get();
                    Optional optionalKey = instance.getData().resource().get().m_203543_();
                    if (optionalKey.isEmpty() || !container.hasPower((ResourceKey)optionalKey.get())) {
                        value = instance.getData().value();
                    } else {
                        @Nullable Holder<ConfiguredPower<C, F>> p = container.getPower((ResourceKey)optionalKey.get());
                        if (p != null && ((ConfiguredPower)p.get()).asVariableIntPower().isPresent()) {
                            value = ((ConfiguredPower)p.m_203334_()).asVariableIntPower().get().getValue((ConfiguredPower)p.get(), entity);
                        }
                    }
                }
            } else {
                value = instance.getData().value();
            }
            if (!instance.getData().modifiers().isEmpty()) {
                List<ConfiguredModifier<?>> modifiers = instance.getData().modifiers();
                value = ModifierUtil.applyModifiers(entity, modifiers, value);
            }
            return value;
        }).collect(Collectors.toList()), (Object)base, (Object)current);
    }

    private static Codec<ModifierOperation> createCodec() {
        final Supplier<ForgeRegistry> supplier = () -> (ForgeRegistry)ApoliRegistries.MODIFIER_OPERATION.get();
        return new Codec<ModifierOperation>(){

            public <U> DataResult<Pair<ModifierOperation, U>> decode(DynamicOps<U> dynamicOps, U input) {
                return dynamicOps.compressMaps() ? dynamicOps.getNumberValue(input).flatMap(arg_0 -> 1.lambda$decode$1((Supplier)supplier, arg_0)).map(obj -> Pair.of((Object)obj, (Object)dynamicOps.empty())) : Codec.STRING.decode(dynamicOps, input).flatMap(arg_0 -> 1.lambda$decode$5((Supplier)supplier, arg_0));
            }

            public <T> DataResult<T> encode(ModifierOperation input, DynamicOps<T> ops, T prefix) {
                return STRICT_CODEC.encode((Object)input, ops, prefix);
            }

            private static /* synthetic */ DataResult lambda$decode$5(Supplier supplier2, Pair pair) {
                ResourceLocation location;
                try {
                    String string;
                    switch (string = ((String)pair.getFirst()).toLowerCase(Locale.ROOT)) {
                        case "addition": {
                            location = ApoliAPI.identifier("add_base_early");
                            break;
                        }
                        case "multiply_base": {
                            location = ApoliAPI.identifier("multiply_base_additive");
                            break;
                        }
                        case "multiply_total": {
                            location = ApoliAPI.identifier("multiply_total_multiplicative");
                            break;
                        }
                        default: {
                            if (!string.contains(":")) {
                                location = ApoliAPI.identifier(string);
                                break;
                            }
                            location = ResourceLocation.m_135822_((String)string, (char)':');
                            break;
                        }
                    }
                }
                catch (ResourceLocationException ex) {
                    return DataResult.error(() -> "Not a valid resource location: " + (String)pair.getFirst() + " " + ex.getMessage());
                }
                ModifierOperation object = (ModifierOperation)((ForgeRegistry)supplier2.get()).getValue(location);
                if (object == null && NamespaceAlias.hasAlias(location)) {
                    object = (ModifierOperation)((ForgeRegistry)supplier2.get()).getValue(NamespaceAlias.resolveAlias(location));
                }
                return object == null ? DataResult.error(() -> "Unknown registry key: " + (String)pair.getFirst()) : DataResult.success((Object)Pair.of((Object)object, (Object)pair.getSecond()));
            }

            private static /* synthetic */ DataResult lambda$decode$1(Supplier supplier2, Number number) {
                ModifierOperation object = (ModifierOperation)((ForgeRegistry)supplier2.get()).getValue(number.intValue());
                return object == null ? DataResult.error(() -> "Unknown registry id: " + number) : DataResult.success((Object)object);
            }
        };
    }

    public static enum Phase {
        BASE,
        TOTAL;

    }
}

