/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.power.configuration;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import io.github.edwinmindcraft.apoli.api.power.IHudRenderedPower;
import io.github.edwinmindcraft.apoli.api.power.IVariableIntPower;
import io.github.edwinmindcraft.apoli.api.power.PowerData;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.api.registry.ApoliBuiltinRegistries;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.github.edwinmindcraft.calio.api.network.CodecSet;
import io.github.edwinmindcraft.calio.api.registry.DynamicRegistryListener;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfiguredPower<C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>>
extends CapabilityProvider<ConfiguredPower<?, ?>>
implements IDynamicFeatureConfiguration,
DynamicRegistryListener {
    public static final Codec<ConfiguredPower<?, ?>> CODEC = PowerFactory.CODEC.dispatch(ConfiguredPower::getFactory, PowerFactory::getCodec);
    public static final CodecSet<ConfiguredPower<?, ?>> CODEC_SET = CalioCodecHelper.forDynamicRegistry(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, (Codec)SerializableDataTypes.IDENTIFIER, CODEC);
    public static final Codec<Holder<ConfiguredPower<?, ?>>> HOLDER = CODEC_SET.holder();
    private final Lazy<F> factory;
    private final C configuration;
    private final PowerData data;
    private final Supplier<F> factorySupplier;
    private final Lazy<PowerType<?>> type = Lazy.of(() -> new PowerType(this));
    private ResourceLocation registryName;

    public static MapCodec<Holder<ConfiguredPower<?, ?>>> required(String name) {
        return HOLDER.fieldOf(name);
    }

    public static MapCodec<Optional<Holder<ConfiguredPower<?, ?>>>> optional(String name) {
        return CalioCodecHelper.optionalField(HOLDER, (String)name);
    }

    public ConfiguredPower(Supplier<F> factory, C configuration, PowerData data) {
        this(null, factory, configuration, data);
    }

    private ConfiguredPower(@Nullable ResourceLocation key, Supplier<F> factory, C configuration, PowerData data) {
        super(ApoliBuiltinRegistries.CONFIGURED_POWER_CLASS);
        RegistryObject ro;
        this.registryName = key;
        this.configuration = configuration;
        this.data = data;
        this.factorySupplier = factory;
        this.factory = Lazy.of(() -> {
            PowerFactory f = (PowerFactory)factory.get();
            this.gatherCapabilities(f::initCapabilities);
            return f;
        });
        if (!(factory instanceof RegistryObject) || (ro = (RegistryObject)factory).isPresent()) {
            this.factory.get();
        }
    }

    public PowerData getData() {
        return this.data;
    }

    public Map<String, Holder<ConfiguredPower<?, ?>>> getContainedPowers() {
        return ((PowerFactory)this.getFactory()).getContainedPowers(this);
    }

    public Set<ResourceKey<ConfiguredPower<?, ?>>> getContainedPowerKeys() {
        return ((PowerFactory)this.getFactory()).getContainedPowerKeys(this);
    }

    public boolean isActive(Entity entity) {
        return this.getConfiguration().isConfigurationValid() && ((PowerFactory)this.getFactory()).isActive(this, entity);
    }

    public void onGained(Entity entity) {
        ((PowerFactory)this.getFactory()).onGained((ConfiguredPower)this, entity);
    }

    public void onRemoved(Entity entity) {
        ((PowerFactory)this.getFactory()).onRemoved((ConfiguredPower)this, entity);
    }

    public void onLost(Entity entity) {
        ((PowerFactory)this.getFactory()).onLost((ConfiguredPower)this, entity);
    }

    public void onAdded(Entity entity) {
        ((PowerFactory)this.getFactory()).onAdded((ConfiguredPower)this, entity);
    }

    public void onRespawn(Entity entity) {
        ((PowerFactory)this.getFactory()).onRespawn((ConfiguredPower)this, entity);
    }

    public <T> T getPowerData(Entity player, NonNullSupplier<? extends T> supplier) {
        return (T)IPowerContainer.get(player).resolve().map(container -> this.getPowerData((IPowerContainer)container, supplier)).orElseGet(() -> supplier.get());
    }

    public <T> T getPowerData(IPowerContainer container, NonNullSupplier<? extends T> supplier) {
        if (this.registryName == null) {
            return container.getPowerData(Holder.m_205709_((Object)this), supplier);
        }
        return container.getPowerData(ResourceKey.m_135785_(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, (ResourceLocation)this.registryName), supplier);
    }

    public Set<Holder<ConfiguredPower<?, ?>>> getChildren() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.getContainedPowers().values().forEach(value -> {
            if (value.m_203633_()) {
                builder.add(value).addAll(((ConfiguredPower)value.m_203334_()).getChildren());
            }
        });
        return builder.build();
    }

    public Set<ResourceKey<ConfiguredPower<?, ?>>> getChildrenKeys() {
        MappedRegistry<ConfiguredPower<?, ?>> registry = ApoliAPI.getPowers();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ResourceKey<ConfiguredPower<?, ?>> value : this.getContainedPowerKeys()) {
            builder.add(value);
            registry.m_203636_(value).filter(Holder::m_203633_).ifPresent(x -> builder.addAll(((ConfiguredPower)x.m_203334_()).getChildrenKeys()));
        }
        return builder.build();
    }

    public CompoundTag serialize(IPowerContainer container) {
        CompoundTag tag = new CompoundTag();
        CompoundTag caps = this.serializeCaps();
        if (caps != null && !caps.m_128456_()) {
            tag.m_128365_("ForgeCaps", (Tag)caps);
        }
        ((PowerFactory)this.getFactory()).serialize(this, container, tag);
        return tag;
    }

    public void deserialize(IPowerContainer container, CompoundTag tag) {
        ((PowerFactory)this.getFactory()).deserialize(this, container, tag);
    }

    public void tick(Entity entity, boolean force) {
        if (((PowerFactory)this.getFactory()).canTick(this, entity)) {
            int i;
            if (!(force || (i = ((PowerFactory)this.getFactory()).tickInterval((ConfiguredPower)this, entity)) > 0 && entity.f_19797_ % i == 0)) {
                return;
            }
            ((PowerFactory)this.getFactory()).tick((ConfiguredPower)this, entity);
        }
    }

    public void tick(Entity entity) {
        this.tick(entity, false);
    }

    public Optional<IVariableIntPower<C>> asVariableIntPower() {
        F f = this.getFactory();
        if (f instanceof IVariableIntPower) {
            IVariableIntPower variableIntPower = (IVariableIntPower)f;
            return Optional.of(variableIntPower);
        }
        return Optional.empty();
    }

    public OptionalInt assign(Entity entity, int value) {
        return this.asVariableIntPower().map(t -> t.assign(this, entity, value)).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public OptionalInt getValue(Entity entity) {
        return this.asVariableIntPower().map(t -> t.getValue(this, entity)).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public OptionalInt getMaximum(Entity entity) {
        return this.asVariableIntPower().map(t -> t.getMaximum(this, entity)).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public OptionalInt getMinimum(Entity entity) {
        return this.asVariableIntPower().map(t -> t.getMinimum(this, entity)).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public OptionalInt change(Entity entity, int amount) {
        return this.asVariableIntPower().map(t -> t.change(this, entity, amount)).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public OptionalInt increment(Entity entity) {
        return this.asVariableIntPower().map(t -> t.increment(this, entity)).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public OptionalInt decrement(Entity entity) {
        return this.asVariableIntPower().map(t -> t.decrement(this, entity)).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public Optional<IHudRenderedPower<C>> asHudRendered() {
        Optional<IHudRenderedPower<C>> optional;
        F f = this.getFactory();
        if (f instanceof IHudRenderedPower) {
            IHudRenderedPower hudRenderedPower = (IHudRenderedPower)f;
            optional = Optional.of(hudRenderedPower);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Optional<HudRender> getRenderSettings(Entity entity) {
        return this.asHudRendered().map(x -> x.getRenderSettings(this, entity));
    }

    public Optional<Boolean> shouldRender(Entity entity) {
        return this.asHudRendered().map(x -> x.shouldRender(this, entity));
    }

    public Optional<Float> getFill(Entity entity) {
        return this.asHudRendered().map(x -> Float.valueOf(x.getFill(this, entity)));
    }

    public Optional<IActivePower<C>> asActive() {
        Optional<IActivePower<C>> optional;
        F f = this.getFactory();
        if (f instanceof IActivePower) {
            IActivePower hudRenderedPower = (IActivePower)f;
            optional = Optional.of(hudRenderedPower);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public boolean activate(Entity entity) {
        Optional<IActivePower<C>> ciActivePower = this.asActive();
        ciActivePower.ifPresent(x -> x.activate(this, entity));
        return ciActivePower.isPresent();
    }

    public Optional<IActivePower.Key> getKey(@Nullable Entity entity) {
        return this.asActive().map(x -> x.getKey(this, entity));
    }

    public ConfiguredPower<C, F> complete(ResourceLocation name) {
        ConfiguredPower<C, F> power = new ConfiguredPower<C, F>(name, this.factorySupplier, ((PowerFactory)this.factorySupplier.get()).complete(name, this.getConfiguration()), this.getData().complete(name));
        this.invalidateCaps();
        return power;
    }

    public F getFactory() {
        return (F)((PowerFactory)this.factory.get());
    }

    public C getConfiguration() {
        return this.configuration;
    }

    @Override
    @NotNull
    public List<String> getErrors(@NotNull ICalioDynamicRegistryManager server) {
        return this.getConfiguration().getErrors(server);
    }

    @Override
    @NotNull
    public List<String> getWarnings(@NotNull ICalioDynamicRegistryManager server) {
        return this.getConfiguration().getWarnings(server);
    }

    @Override
    public boolean isConfigurationValid() {
        return this.getConfiguration().isConfigurationValid();
    }

    public String toString() {
        String str = "CP:" + ApoliRegistries.POWER_FACTORY.get().getKey(this.getFactory()) + "(" + this.getData() + ")-" + this.getConfiguration();
        return this.registryName != null ? "[" + this.registryName + "]" + str : str;
    }

    public PowerType<?> getPowerType() {
        return (PowerType)this.type.get();
    }

    public int hashCode() {
        return this.registryName != null ? this.registryName.hashCode() : Objects.hash(this.factory, this.configuration, this.data);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfiguredPower)) {
            return false;
        }
        ConfiguredPower other = (ConfiguredPower)obj;
        if (this.registryName != null && other.registryName != null) {
            return Objects.equals(this.registryName, other.registryName);
        }
        return Objects.equals(this.factorySupplier.get(), other.factorySupplier.get()) && Objects.equals(this.configuration, other.configuration) && Objects.equals(this.data, other.data);
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        if (this.registryName != null) {
            return this.registryName;
        }
        return ApoliAPI.getPowers().m_7854_((Object)this).map(ResourceKey::m_135782_).orElse(null);
    }

    public void whenAvailable(@NotNull ICalioDynamicRegistryManager manager) {
        F f = this.getFactory();
        if (f instanceof DynamicRegistryListener) {
            DynamicRegistryListener drl = (DynamicRegistryListener)f;
            drl.whenAvailable(manager);
        }
    }

    public void whenNamed(@NotNull ResourceLocation name) {
        if (this.registryName == null) {
            this.registryName = name;
        } else if (!Objects.equals(this.registryName, name)) {
            throw new IllegalArgumentException("Tried to assign name \"" + name + "\" to power with name \"" + this.registryName + "\"");
        }
        F f = this.getFactory();
        if (f instanceof DynamicRegistryListener) {
            DynamicRegistryListener drl = (DynamicRegistryListener)f;
            drl.whenNamed(name);
        }
    }
}

