/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.power;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.github.edwinmindcraft.calio.common.util.ForgeConditionCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.apache.commons.lang3.StringUtils;

public record PowerData(List<ConfiguredEntityCondition<?, ?>> conditions, boolean hidden, int loadingPriority, Optional<ICondition> forgeCondition, String name, String description) {
    public static final PowerData DEFAULT = new PowerData((List<ConfiguredEntityCondition<?, ?>>)ImmutableList.of(), false, 0, Optional.empty(), "", "");
    public static final MapCodec<PowerData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.listOf(ConfiguredEntityCondition.CODEC, (String)"condition", (String)"conditions").forGetter(PowerData::conditions), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"hidden", (Object)false).forGetter(PowerData::hidden), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.INT, (String)"loading_priority", (Object)0).forGetter(PowerData::loadingPriority), (App)CalioCodecHelper.optionalField((Codec)ForgeConditionCodec.INSTANCE, (String)"forge:conditions").forGetter(PowerData::forgeCondition), (App)CalioCodecHelper.optionalField((Codec)Codec.STRING, (String)"name", (Object)"").forGetter(PowerData::name), (App)CalioCodecHelper.optionalField((Codec)Codec.STRING, (String)"description", (Object)"").forGetter(PowerData::description)).apply((Applicative)instance, PowerData::new));

    public static Builder builder() {
        return new Builder();
    }

    public MutableComponent getName() {
        return Component.m_237115_((String)this.name());
    }

    public MutableComponent getDescription() {
        return Component.m_237115_((String)this.description());
    }

    public PowerData complete(ResourceLocation identifier) {
        return new PowerData(this.conditions, this.hidden, this.loadingPriority, this.forgeCondition, (String)(StringUtils.isEmpty((CharSequence)this.name) ? "power." + identifier.m_135827_() + "." + identifier.m_135815_() + ".name" : this.name), (String)(StringUtils.isEmpty((CharSequence)this.description) ? "power." + identifier.m_135827_() + "." + identifier.m_135815_() + ".description" : this.description));
    }

    public Builder copyOf() {
        Builder builder = PowerData.builder().hidden(this.hidden).withPriority(this.loadingPriority).withName(this.name).withDescription(this.description);
        this.conditions.forEach(builder::addCondition);
        return builder;
    }

    public static class Builder {
        private final List<ConfiguredEntityCondition<?, ?>> conditions = new ArrayList();
        private boolean hidden = false;
        private int loadingPriority = 0;
        private Optional<ICondition> forgeCondition = Optional.empty();
        private String name = "";
        private String description = "";

        public List<ConfiguredEntityCondition<?, ?>> getConditions() {
            return this.conditions;
        }

        public Builder hidden() {
            this.hidden = true;
            return this;
        }

        public Builder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder withPriority(int priority) {
            this.loadingPriority = priority;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withIdentifier(ResourceLocation identifier) {
            this.name = "power." + identifier.m_135827_() + "." + identifier.m_135815_() + ".name";
            this.description = "power." + identifier.m_135827_() + "." + identifier.m_135815_() + ".description";
            return this;
        }

        public Builder addCondition(ConfiguredEntityCondition<?, ?> condition) {
            this.conditions.add(condition);
            return this;
        }

        public Builder withForgeCondition(ICondition forgeCondition) {
            this.forgeCondition = Optional.of(forgeCondition);
            return this;
        }

        public PowerData build() {
            return new PowerData(this.conditions, this.hidden, this.loadingPriority, this.forgeCondition, this.name, this.description);
        }
    }
}

