/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.component;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.integration.ModifyValueEvent;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.IValueModifyingPower;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.apoli.common.power.AttributeModifyTransferPower;
import io.github.edwinmindcraft.apoli.common.registry.ApoliCapabilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IPowerContainer {
    public static final ResourceLocation KEY = Apoli.identifier("powers");

    @NotNull
    public static LazyOptional<IPowerContainer> get(@Nullable Entity entity) {
        return entity == null ? LazyOptional.empty() : entity.getCapability(ApoliCapabilities.POWER_CONTAINER);
    }

    public static void sync(Entity entity) {
        ApoliAPI.synchronizePowerContainer(entity);
    }

    public static void sync(Entity entity, ServerPlayer with) {
        ApoliAPI.synchronizePowerContainer(entity, with);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> void withPower(Entity entity, F factory, @Nullable Predicate<Holder<ConfiguredPower<T, F>>> power, Consumer<Holder<ConfiguredPower<T, F>>> with) {
        IPowerContainer.get(entity).ifPresent(x -> x.getPowers(factory).stream().filter(p -> power == null || power.test((Holder)p)).findAny().ifPresent(with));
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> List<Holder<ConfiguredPower<T, F>>> getPowers(Entity entity, F factory, @NotNull Predicate<Holder<ConfiguredPower<T, F>>> filter) {
        return IPowerContainer.get(entity).map(x -> x.getPowers(factory, filter)).orElseGet(ImmutableList::of);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> List<Holder<ConfiguredPower<T, F>>> getPowers(Entity entity, F factory) {
        return IPowerContainer.get(entity).map(x -> x.getPowers(factory)).orElseGet(ImmutableList::of);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> boolean hasPower(Entity entity, F factory) {
        return IPowerContainer.get(entity).map(x -> x.hasPower(factory)).orElse(false);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> float modify(Entity entity, F factory, float baseValue) {
        return (float)IPowerContainer.modify(entity, factory, (double)baseValue, null, null);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> float modify(Entity entity, F factory, float baseValue, Predicate<Holder<ConfiguredPower<T, F>>> powerFilter) {
        return (float)IPowerContainer.modify(entity, factory, (double)baseValue, powerFilter, null);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> float modify(Entity entity, F factory, float baseValue, Predicate<Holder<ConfiguredPower<T, F>>> powerFilter, Consumer<Holder<ConfiguredPower<T, F>>> powerAction) {
        return (float)IPowerContainer.modify(entity, factory, (double)baseValue, powerFilter, powerAction);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> double modify(Entity entity, F factory, double baseValue) {
        return IPowerContainer.modify(entity, factory, baseValue, null, null);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> double modify(Entity entity, F factory, double baseValue, Predicate<Holder<ConfiguredPower<T, F>>> powerFilter, Consumer<Holder<ConfiguredPower<T, F>>> powerAction) {
        List<Holder<ConfiguredPower<T, F>>> powers = IPowerContainer.getPowers(entity, factory, powerFilter == null ? x -> ((ConfiguredPower)x.m_203334_()).isActive(entity) : x -> ((ConfiguredPower)x.m_203334_()).isActive(entity) && powerFilter.test((Holder)x));
        return IPowerContainer.modify(entity, factory, powers, baseValue, powerAction);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> double modify(Entity entity, F factory, Iterable<Holder<ConfiguredPower<T, F>>> input, double baseValue, Consumer<Holder<ConfiguredPower<T, F>>> powerAction) {
        ArrayList modifiers = new ArrayList();
        for (Holder<ConfiguredPower<T, F>> holder : input) {
            if (!holder.m_203633_()) continue;
            modifiers.addAll(((IValueModifyingPower)((ConfiguredPower)holder.m_203334_()).getFactory()).getModifiers((ConfiguredPower)holder.m_203334_(), entity));
            if (powerAction == null) continue;
            powerAction.accept(holder);
        }
        modifiers.addAll(AttributeModifyTransferPower.apply(entity, factory));
        ModifyValueEvent event = new ModifyValueEvent(entity, factory, baseValue, modifiers);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return ModifierUtil.applyModifiers(entity, event.getModifiers(), baseValue);
    }

    @Contract(mutates="this")
    default public void removePower(ResourceLocation power, ResourceLocation source) {
        this.removePower(ResourceKey.m_135785_(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, (ResourceLocation)power), source);
    }

    @Contract(mutates="this")
    public void removePower(ResourceKey<ConfiguredPower<?, ?>> var1, ResourceLocation var2);

    @Contract(mutates="this")
    public int removeAllPowersFromSource(ResourceLocation var1);

    @NotNull
    public List<ResourceKey<ConfiguredPower<?, ?>>> getPowersFromSource(ResourceLocation var1);

    @Contract(mutates="this")
    default public boolean addPower(ResourceLocation power, ResourceLocation source) {
        return this.addPower(ResourceKey.m_135785_(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, (ResourceLocation)power), source);
    }

    @Contract(mutates="this")
    public boolean addPower(ResourceKey<ConfiguredPower<?, ?>> var1, ResourceLocation var2);

    @Contract(pure=true)
    default public boolean hasPower(@Nullable ResourceLocation power) {
        return this.hasPower(power == null ? null : ResourceKey.m_135785_(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, (ResourceLocation)power));
    }

    @Contract(pure=true)
    public boolean hasPower(@Nullable ResourceKey<ConfiguredPower<?, ?>> var1);

    public boolean hasPower(PowerFactory<?> var1);

    @Contract(pure=true)
    default public boolean hasPower(ResourceLocation power, ResourceLocation source) {
        return this.hasPower(ResourceKey.m_135785_(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, (ResourceLocation)power), source);
    }

    @Contract(pure=true)
    public boolean hasPower(ResourceKey<ConfiguredPower<?, ?>> var1, ResourceLocation var2);

    @Nullable
    @Contract(value="null -> null", pure=true)
    default public <C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>> Holder<ConfiguredPower<C, F>> getPower(@Nullable ResourceLocation power) {
        if (power == null) {
            return null;
        }
        return this.getPower(ResourceKey.m_135785_(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, (ResourceLocation)power));
    }

    @Nullable
    @Contract(value="null -> null", pure=true)
    public <C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>> Holder<ConfiguredPower<C, F>> getPower(@Nullable ResourceKey<ConfiguredPower<?, ?>> var1);

    @NotNull
    @Contract(pure=true)
    public List<Holder<ConfiguredPower<?, ?>>> getPowers();

    @NotNull
    @Contract(pure=true)
    default public Set<ResourceKey<ConfiguredPower<?, ?>>> getPowerNames() {
        return this.getPowerTypes(true);
    }

    @NotNull
    @Contract(pure=true)
    public Set<ResourceKey<ConfiguredPower<?, ?>>> getPowerTypes(boolean var1);

    @NotNull
    @Contract(pure=true)
    default public <C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>> List<Holder<ConfiguredPower<C, F>>> getPowers(F factory) {
        return this.getPowers(factory, false);
    }

    @NotNull
    @Contract(pure=true)
    public <C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>> List<Holder<ConfiguredPower<C, F>>> getPowers(F var1, @NotNull Predicate<Holder<ConfiguredPower<C, F>>> var2);

    @NotNull
    @Contract(pure=true)
    default public <C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>> List<Holder<ConfiguredPower<C, F>>> getPowers(F factory, boolean includeInactive) {
        return this.getPowers(factory, includeInactive ? x -> true : x -> ((ConfiguredPower)x.m_203334_()).isActive(this.getOwner()));
    }

    @NotNull
    @Contract(pure=true)
    default public List<ResourceLocation> getSources(ResourceLocation power) {
        return this.getSources(ResourceKey.m_135785_(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, (ResourceLocation)power));
    }

    @NotNull
    @Contract(pure=true)
    public List<ResourceLocation> getSources(ResourceKey<ConfiguredPower<?, ?>> var1);

    @Contract(pure=true)
    public void sync();

    @Contract(mutates="this")
    public void serverTick();

    @Contract(mutates="this")
    default public void readFromNbt(CompoundTag tag) {
        this.readNbt(tag, true);
    }

    @Contract(mutates="this")
    public void readNbt(CompoundTag var1, boolean var2);

    public void rebuildCache();

    @Contract(mutates="this")
    public void handle(Multimap<ResourceLocation, ResourceLocation> var1, Map<ResourceLocation, CompoundTag> var2);

    @Contract(mutates="param")
    public CompoundTag writeToNbt(CompoundTag var1);

    @NotNull
    public <T> T getPowerData(ResourceKey<ConfiguredPower<?, ?>> var1, NonNullSupplier<? extends T> var2);

    @NotNull
    default public <T> T getPowerData(Holder<ConfiguredPower<?, ?>> power, NonNullSupplier<? extends T> supplier) {
        ResourceKey key = (ResourceKey)((Optional)power.m_203439_().map(Optional::of, pow -> ApoliAPI.getPowers(this.getOwner().m_20194_()).m_7854_(pow))).orElseThrow(() -> new IllegalArgumentException("Cannot create data for unregistered power: " + power));
        return this.getPowerData(key, supplier);
    }

    public Entity getOwner();
}

