/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.github.edwinmindcraft.apoli.common.action.meta.ChanceConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.ChoiceConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.DelayAction;
import io.github.edwinmindcraft.apoli.common.action.meta.ExecuteMultipleConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.IDelegatedActionConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.IfElseConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.IfElseListConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.NothingConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.SideConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConditionStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConstantConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.IDelegatedConditionConfiguration;
import io.github.edwinmindcraft.calio.api.network.CodecSet;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraftforge.registries.DeferredRegister;

public class MetaFactories {
    public static <F, C, V> void defineMetaConditions(DeferredRegister<F> registry, Function<Codec<? extends IDelegatedConditionConfiguration<V>>, ? extends F> func, CodecSet<C> conditionCodec, BiPredicate<C, V> predicate) {
        registry.register("constant", () -> func.apply(ConstantConfiguration.codec()));
        registry.register("and", () -> func.apply(ConditionStreamConfiguration.andCodec(conditionCodec, predicate)));
        registry.register("or", () -> func.apply(ConditionStreamConfiguration.orCodec(conditionCodec, predicate)));
    }

    public static <F, A, C, V> void defineMetaActions(DeferredRegister<F> registry, Function<Codec<? extends IDelegatedActionConfiguration<V>>, ? extends F> func, CodecSet<A> actionCodec, CodecSet<C> conditionCodec, Function<String, MapCodec<Holder<A>>> optional, BiConsumer<A, V> executor, BiPredicate<C, V> predicate, Predicate<V> serverSidePredicate) {
        registry.register("and", () -> func.apply(ExecuteMultipleConfiguration.codec(actionCodec, executor)));
        registry.register("chance", () -> func.apply(ChanceConfiguration.codec(actionCodec, executor)));
        registry.register("if_else", () -> func.apply(IfElseConfiguration.codec(conditionCodec, actionCodec, optional, predicate, executor)));
        registry.register("if_else_list", () -> func.apply(IfElseListConfiguration.codec(conditionCodec, actionCodec, predicate, executor)));
        registry.register("choice", () -> func.apply(ChoiceConfiguration.codec(actionCodec, executor)));
        registry.register("delay", () -> func.apply(DelayAction.codec(actionCodec, executor)));
        registry.register("side", () -> func.apply(SideConfiguration.codec(actionCodec, serverSidePredicate, executor)));
        registry.register("nothing", () -> func.apply(NothingConfiguration.codec()));
    }
}

