/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.apace100.apoli.Apoli;
import io.github.edwinmindcraft.apoli.api.configuration.MustBeBound;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IDynamicFeatureConfiguration {
    public static void populate(BiConsumer<String, IDynamicFeatureConfiguration> consumer, Iterable<?> iterable, String prefix) {
        int i = 0;
        for (Object o : iterable) {
            if (o instanceof IDynamicFeatureConfiguration) {
                IDynamicFeatureConfiguration config = (IDynamicFeatureConfiguration)o;
                consumer.accept(prefix + i, config);
            } else if (o instanceof Map) {
                Map map = (Map)o;
                IDynamicFeatureConfiguration.populate(consumer, map, prefix + i + "/");
            } else if (o instanceof Iterable) {
                Iterable iterable2 = (Iterable)o;
                IDynamicFeatureConfiguration.populate(consumer, iterable2, prefix + i + "/");
            }
            ++i;
        }
    }

    public static void populate(BiConsumer<String, IDynamicFeatureConfiguration> consumer, Map<?, ?> map, String prefix) {
        map.forEach((o, o2) -> {
            String key = "?";
            if (o instanceof String) {
                String str;
                key = str = (String)o;
            } else if (o instanceof StringRepresentable) {
                StringRepresentable identifiable = (StringRepresentable)o;
                key = identifiable.m_7912_();
            }
            if (o2 instanceof IDynamicFeatureConfiguration) {
                IDynamicFeatureConfiguration config = (IDynamicFeatureConfiguration)o2;
                consumer.accept(prefix + key, config);
            } else if (o2 instanceof Map) {
                Map map2 = (Map)o2;
                IDynamicFeatureConfiguration.populate(consumer, map2, prefix + key + "/");
            } else if (o2 instanceof Iterable) {
                Iterable iterable = (Iterable)o2;
                IDynamicFeatureConfiguration.populate(consumer, iterable, prefix + key + "/");
            }
        });
    }

    @NotNull
    default public List<String> getErrors(@NotNull ICalioDynamicRegistryManager server) {
        return this.getChildrenComponent().entrySet().stream().flatMap(entry -> this.copyErrorsFrom((IDynamicFeatureConfiguration)entry.getValue(), server, this.name(), (String)entry.getKey()).stream()).toList();
    }

    @NotNull
    default public List<String> getWarnings(@NotNull ICalioDynamicRegistryManager server) {
        return this.getChildrenComponent().entrySet().stream().flatMap(entry -> this.copyWarningsFrom((IDynamicFeatureConfiguration)entry.getValue(), server, this.name(), (String)entry.getKey()).stream()).toList();
    }

    @NotNull
    default public String name() {
        String name = this.getClass().getSimpleName();
        if (name.endsWith("Configuration")) {
            return name.substring(0, name.length() - "Configuration".length());
        }
        return name;
    }

    @NotNull
    default public Map<String, IDynamicFeatureConfiguration> getChildrenComponent() {
        HashMap builder = new HashMap();
        this.forChildren(builder::put);
        return ImmutableMap.copyOf(builder);
    }

    default public void forChildren(BiConsumer<String, IDynamicFeatureConfiguration> consumer) {
        RecordComponent[] recordComponentArray = this;
        if (recordComponentArray instanceof Record) {
            Record record = (Record)recordComponentArray;
            for (RecordComponent component : record.getClass().getRecordComponents()) {
                try {
                    Object invoke = component.getAccessor().invoke((Object)record, new Object[0]);
                    if (invoke instanceof IDynamicFeatureConfiguration) {
                        IDynamicFeatureConfiguration config = (IDynamicFeatureConfiguration)invoke;
                        consumer.accept(component.getName(), config);
                        continue;
                    }
                    if (invoke instanceof Map) {
                        Map map = (Map)invoke;
                        IDynamicFeatureConfiguration.populate(consumer, map, component.getName() + "/");
                        continue;
                    }
                    if (!(invoke instanceof Iterable)) continue;
                    Iterable iterable = (Iterable)invoke;
                    IDynamicFeatureConfiguration.populate(consumer, iterable, component.getName() + "/");
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    Apoli.LOGGER.warn("Failed to access record component \"{}\" for \"{}\", auto logging may fail.", (Object)component, (Object)this.name());
                    Apoli.LOGGER.debug((Object)e);
                }
            }
        }
    }

    default public boolean isConfigurationValid() {
        return true;
    }

    public static String holderAsString(String name, Holder<?> holder) {
        if (holder instanceof Holder.Reference) {
            Holder.Reference ref = (Holder.Reference)holder;
            return name + ": " + ref.m_205785_();
        }
        return name;
    }

    default public List<String> getUnbound() {
        ImmutableList.Builder builder = ImmutableList.builder();
        RecordComponent[] recordComponentArray = this;
        if (recordComponentArray instanceof Record) {
            Record record = (Record)recordComponentArray;
            for (RecordComponent component : record.getClass().getRecordComponents()) {
                if (component.getAnnotation(MustBeBound.class) == null) continue;
                try {
                    HolderSet set;
                    Holder holder2;
                    Object invoke = component.getAccessor().invoke((Object)record, new Object[0]);
                    if (invoke instanceof Holder && !(holder2 = (Holder)invoke).m_203633_()) {
                        builder.add((Object)IDynamicFeatureConfiguration.holderAsString(component.getName(), holder2));
                        continue;
                    }
                    if (!(invoke instanceof HolderSet) || !((set = (HolderSet)invoke) instanceof HolderSet.Direct)) continue;
                    HolderSet.Direct direct = (HolderSet.Direct)set;
                    direct.m_203614_().forEach(holder -> builder.add((Object)IDynamicFeatureConfiguration.holderAsString(component.getName(), holder)));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    Apoli.LOGGER.warn("Failed to access record component \"{}\" for \"{}\", auto logging may fail.", (Object)component, (Object)this.name());
                    Apoli.LOGGER.debug((Object)e);
                }
            }
        }
        return builder.build();
    }

    default public List<String> getMissingBinds() {
        ImmutableList.Builder builder = ImmutableList.builder().addAll(this.getUnbound());
        this.forChildren((path, configuration) -> configuration.getUnbound().forEach(s -> builder.add((Object)"%s/%s".formatted(path, s))));
        return builder.build();
    }

    @NotNull
    default public List<ResourceLocation> checkPower(@NotNull ICalioDynamicRegistryManager dynamicRegistryManager, ResourceLocation ... identifiers) {
        MappedRegistry powers = dynamicRegistryManager.get(ApoliDynamicRegistries.CONFIGURED_POWER_KEY);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ResourceLocation identifier : identifiers) {
            if (powers.m_7804_(identifier)) continue;
            builder.add((Object)identifier);
        }
        return builder.build();
    }

    default public UnaryOperator<String> fieldName(String name, String ... fields) {
        StringBuilder key = new StringBuilder(name);
        Arrays.stream(fields).flatMap(x -> Arrays.stream(x.split("/"))).filter(x -> !StringUtils.isBlank((CharSequence)x)).forEach(s -> key.append("[").append((String)s).append("]"));
        String val = key.append("/%s").toString();
        return xva$0 -> val.formatted(xva$0);
    }

    default public List<String> copyErrorsFrom(@Nullable IDynamicFeatureConfiguration config, ICalioDynamicRegistryManager server, String name, String ... fields) {
        if (config == null) {
            return ImmutableList.of();
        }
        return config.getErrors(server).stream().map(this.fieldName(name, fields)).toList();
    }

    default public List<String> copyWarningsFrom(@Nullable IDynamicFeatureConfiguration config, ICalioDynamicRegistryManager server, String name, String ... fields) {
        if (config == null) {
            return ImmutableList.of();
        }
        return config.getWarnings(server).stream().map(this.fieldName(name, fields)).toList();
    }
}

