/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api;

import io.github.apace100.apoli.util.ApoliConfigs;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.apoli.common.ApoliCommon;
import io.github.edwinmindcraft.apoli.common.network.C2SUseActivePowers;
import io.github.edwinmindcraft.apoli.common.network.S2CSynchronizePowerContainer;
import io.github.edwinmindcraft.calio.api.CalioAPI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ApoliAPI {
    private static final Set<String> ADDITIONAL_DATA_FIELDS = new HashSet<String>();
    private static final Set<String> ADDITIONAL_DATA_FIELDS_VIEW = Collections.unmodifiableSet(ADDITIONAL_DATA_FIELDS);
    public static final String MODID = "apoli";

    @Nullable
    public static IPowerContainer getPowerContainer(Entity entity) {
        LivingEntity living;
        LazyOptional<IPowerContainer> optional;
        if (entity instanceof LivingEntity && (optional = IPowerContainer.get((Entity)(living = (LivingEntity)entity))).isPresent()) {
            return (IPowerContainer)optional.orElseThrow(RuntimeException::new);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void performPowers(Set<ResourceLocation> powers) {
        ApoliCommon.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SUseActivePowers(powers));
    }

    public static boolean enableFoodRestrictions() {
        return (Boolean)ApoliConfigs.SERVER.enforceFoodRestrictions.get();
    }

    public static void synchronizePowerContainer(Entity living) {
        S2CSynchronizePowerContainer packet = S2CSynchronizePowerContainer.forEntity(living);
        if (packet != null && !living.m_9236_().m_5776_()) {
            ApoliCommon.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> living), (Object)packet);
        }
    }

    public static void synchronizePowerContainer(Entity living, ServerPlayer with) {
        S2CSynchronizePowerContainer packet = S2CSynchronizePowerContainer.forEntity(living);
        if (packet != null) {
            ApoliCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> with), (Object)packet);
        }
    }

    public static ResourceLocation identifier(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static void addAdditionalDataField(String name) {
        ADDITIONAL_DATA_FIELDS.add(name);
    }

    public static Set<String> getAdditionalDataFields() {
        return ADDITIONAL_DATA_FIELDS_VIEW;
    }

    public static boolean isAdditionalDataField(String name) {
        return ADDITIONAL_DATA_FIELDS_VIEW.contains(name);
    }

    public static MappedRegistry<ConfiguredPower<?, ?>> getPowers(@Nullable MinecraftServer server) {
        return CalioAPI.getDynamicRegistries((MinecraftServer)server).get(ApoliDynamicRegistries.CONFIGURED_POWER_KEY);
    }

    public static MappedRegistry<ConfiguredPower<?, ?>> getPowers(@Nullable RegistryAccess access) {
        return CalioAPI.getDynamicRegistries((RegistryAccess)access).get(ApoliDynamicRegistries.CONFIGURED_POWER_KEY);
    }

    public static MappedRegistry<ConfiguredPower<?, ?>> getPowers() {
        return CalioAPI.getDynamicRegistries().get(ApoliDynamicRegistries.CONFIGURED_POWER_KEY);
    }
}

